/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.util.LRUMap;

public class CachedMap<T>
implements IBackingMap<T> {
    LRUMap<List<Object>, T> cache;
    IBackingMap<T> delegate;

    public CachedMap(IBackingMap<T> delegate, int cacheSize) {
        this.cache = new LRUMap(cacheSize);
        this.delegate = delegate;
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        HashMap<List, Object> results = new HashMap<List, Object>();
        ArrayList<List<Object>> toGet = new ArrayList<List<Object>>();
        for (List<Object> key : keys) {
            if (this.cache.containsKey(key)) {
                results.put(key, this.cache.get(key));
                continue;
            }
            toGet.add(key);
        }
        List<T> fetchedVals = this.delegate.multiGet(toGet);
        for (int i = 0; i < toGet.size(); ++i) {
            List key = (List)toGet.get(i);
            T val = fetchedVals.get(i);
            this.cache.put(key, val);
            results.put(key, val);
        }
        ArrayList ret = new ArrayList(keys.size());
        for (List<Object> key : keys) {
            ret.add(results.get(key));
        }
        return ret;
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> values) {
        this.cache(keys, values);
        this.delegate.multiPut(keys, values);
    }

    private void cache(List<List<Object>> keys, List<T> values) {
        for (int i = 0; i < keys.size(); ++i) {
            this.cache.put(keys.get(i), values.get(i));
        }
    }
}

