/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.dependency;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.shade.net.minidev.json.JSONValue;
import org.apache.storm.shade.net.minidev.json.parser.ParseException;

public class DependencyPropertiesParser {
    public List<File> parseJarsProperties(String prop) {
        if (prop.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> dependencies = Arrays.asList(prop.split(","));
        return Lists.transform(dependencies, File::new);
    }

    public Map<String, File> parseArtifactsProperties(String prop) {
        try {
            Map parsed = (Map)JSONValue.parseWithException((String)prop);
            LinkedHashMap<String, File> packages = new LinkedHashMap<String, File>(parsed.size());
            for (Map.Entry artifactToFilePath : parsed.entrySet()) {
                packages.put((String)artifactToFilePath.getKey(), new File((String)artifactToFilePath.getValue()));
            }
            return packages;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

