/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class NettySerializableMessageEncoder
extends MessageToByteEncoder<INettySerializable> {
    public static final NettySerializableMessageEncoder INSTANCE = new NettySerializableMessageEncoder();

    private NettySerializableMessageEncoder() {
    }

    protected void encode(ChannelHandlerContext ctx, INettySerializable msg, ByteBuf out) throws Exception {
        msg.write(out);
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, INettySerializable msg, boolean preferDirect) throws Exception {
        return ctx.alloc().ioBuffer(msg.encodeLength());
    }
}

