/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.cgroup;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CpuCore;
import org.apache.storm.metrics2.WorkerMetricRegistrant;
import org.apache.storm.metrics2.cgroup.CGroupMetricsBase;
import org.apache.storm.task.TopologyContext;

public class CGroupCpuStat
extends CGroupMetricsBase
implements WorkerMetricRegistrant {
    public CGroupCpuStat(Map<String, Object> conf) {
        super(conf, SubSystemType.cpu);
    }

    @Override
    public void registerMetrics(TopologyContext topologyContext) {
        if (this.enabled) {
            topologyContext.registerGauge("CGroupCpuStat.nr.period-count", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        CpuCore.Stat stat = ((CpuCore)CGroupCpuStat.this.core).getCpuStat();
                        return stat.nrPeriods;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            topologyContext.registerGauge("CGroupCpuStat.nr.throttled-count", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        CpuCore.Stat stat = ((CpuCore)CGroupCpuStat.this.core).getCpuStat();
                        return stat.nrThrottled;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            topologyContext.registerGauge("CGroupCpuStat.nr.throttled-percentage", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        CpuCore.Stat stat = ((CpuCore)CGroupCpuStat.this.core).getCpuStat();
                        return (long)((double)stat.nrThrottled * 100.0 / (double)stat.nrPeriods);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            topologyContext.registerGauge("CGroupCpuStat.throttled.time-ms", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        CpuCore.Stat stat = ((CpuCore)CGroupCpuStat.this.core).getCpuStat();
                        return Math.round((double)stat.throttledTime / 1000000.0);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

