/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.NullStruct;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.grouping.PartialKeyGrouping;
import org.apache.storm.hooks.IWorkerHook;
import org.apache.storm.lambda.LambdaBiConsumerBolt;
import org.apache.storm.lambda.LambdaConsumerBolt;
import org.apache.storm.lambda.LambdaSpout;
import org.apache.storm.lambda.SerializableBiConsumer;
import org.apache.storm.lambda.SerializableConsumer;
import org.apache.storm.lambda.SerializableSupplier;
import org.apache.storm.shade.net.minidev.json.JSONValue;
import org.apache.storm.spout.CheckpointSpout;
import org.apache.storm.state.State;
import org.apache.storm.topology.BaseConfigurationDeclarer;
import org.apache.storm.topology.BasicBoltExecutor;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.CheckpointTupleForwarder;
import org.apache.storm.topology.ComponentConfigurationDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IComponent;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.IStatefulWindowedBolt;
import org.apache.storm.topology.IWindowedBolt;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.topology.PersistentWindowedBoltExecutor;
import org.apache.storm.topology.SpoutDeclarer;
import org.apache.storm.topology.StatefulBoltExecutor;
import org.apache.storm.topology.StatefulWindowedBoltExecutor;
import org.apache.storm.topology.WindowedBoltExecutor;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.Utils;

public class TopologyBuilder {
    private final Map<String, IRichBolt> bolts = new HashMap<String, IRichBolt>();
    private final Map<String, IRichSpout> spouts = new HashMap<String, IRichSpout>();
    private final Map<String, ComponentCommon> commons = new HashMap<String, ComponentCommon>();
    private final Map<String, Set<String>> componentToSharedMemory = new HashMap<String, Set<String>>();
    private final Map<String, SharedMemory> sharedMemory = new HashMap<String, SharedMemory>();
    private boolean hasStatefulBolt = false;
    private Map<String, StateSpoutSpec> stateSpouts = new HashMap<String, StateSpoutSpec>();
    private List<ByteBuffer> workerHooks = new ArrayList<ByteBuffer>();

    private static String mergeIntoJson(Map<String, Object> into, Map<String, Object> newMap) {
        HashMap<String, Object> res = new HashMap<String, Object>(into);
        res.putAll(newMap);
        return JSONValue.toJSONString(res);
    }

    public StormTopology createTopology() {
        ComponentCommon common;
        HashMap<String, Bolt> boltSpecs = new HashMap<String, Bolt>();
        HashMap<String, SpoutSpec> spoutSpecs = new HashMap<String, SpoutSpec>();
        this.maybeAddCheckpointSpout();
        for (String boltId : this.bolts.keySet()) {
            IRichBolt bolt = this.bolts.get(boltId);
            bolt = this.maybeAddCheckpointTupleForwarder(bolt);
            common = this.getComponentCommon(boltId, bolt);
            try {
                this.maybeAddCheckpointInputs(common);
                boltSpecs.put(boltId, new Bolt(ComponentObject.serialized_java(Utils.javaSerialize(bolt)), common));
            }
            catch (RuntimeException wrapperCause) {
                if (wrapperCause.getCause() != null && NotSerializableException.class.equals(wrapperCause.getCause().getClass())) {
                    throw new IllegalStateException("Bolt '" + boltId + "' contains a non-serializable field of type " + wrapperCause.getCause().getMessage() + ", which was instantiated prior to topology creation. " + wrapperCause.getCause().getMessage() + " should be instantiated within the prepare method of '" + boltId + " at the earliest.", wrapperCause);
                }
                throw wrapperCause;
            }
        }
        for (String spoutId : this.spouts.keySet()) {
            IRichSpout spout = this.spouts.get(spoutId);
            common = this.getComponentCommon(spoutId, spout);
            try {
                spoutSpecs.put(spoutId, new SpoutSpec(ComponentObject.serialized_java(Utils.javaSerialize(spout)), common));
            }
            catch (RuntimeException wrapperCause) {
                if (wrapperCause.getCause() != null && NotSerializableException.class.equals(wrapperCause.getCause().getClass())) {
                    throw new IllegalStateException("Spout '" + spoutId + "' contains a non-serializable field of type " + wrapperCause.getCause().getMessage() + ", which was instantiated prior to topology creation. " + wrapperCause.getCause().getMessage() + " should be instantiated within the open method of '" + spoutId + " at the earliest.", wrapperCause);
                }
                throw wrapperCause;
            }
        }
        StormTopology stormTopology = new StormTopology(spoutSpecs, boltSpecs, new HashMap<String, StateSpoutSpec>());
        stormTopology.set_worker_hooks(this.workerHooks);
        if (!this.componentToSharedMemory.isEmpty()) {
            stormTopology.set_component_to_shared_memory(this.componentToSharedMemory);
            stormTopology.set_shared_memory(this.sharedMemory);
        }
        return Utils.addVersions(stormTopology);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt, Number parallelismHint) throws IllegalArgumentException {
        this.validateUnusedId(id);
        this.initCommon(id, bolt, parallelismHint);
        this.bolts.put(id, bolt);
        return new BoltGetter(id);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt, Number parallelismHint) throws IllegalArgumentException {
        return this.setBolt(id, new BasicBoltExecutor(bolt), parallelismHint);
    }

    public BoltDeclarer setBolt(String id, IWindowedBolt bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IWindowedBolt bolt, Number parallelismHint) throws IllegalArgumentException {
        return this.setBolt(id, new WindowedBoltExecutor(bolt), parallelismHint);
    }

    public <T extends State> BoltDeclarer setBolt(String id, IStatefulBolt<T> bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public <T extends State> BoltDeclarer setBolt(String id, IStatefulBolt<T> bolt, Number parallelismHint) throws IllegalArgumentException {
        this.hasStatefulBolt = true;
        return this.setBolt(id, new StatefulBoltExecutor<T>(bolt), parallelismHint);
    }

    public <T extends State> BoltDeclarer setBolt(String id, IStatefulWindowedBolt<T> bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public <T extends State> BoltDeclarer setBolt(String id, IStatefulWindowedBolt<T> bolt, Number parallelismHint) throws IllegalArgumentException {
        this.hasStatefulBolt = true;
        WindowedBoltExecutor executor = bolt.isPersistent() ? new PersistentWindowedBoltExecutor<T>(bolt) : new StatefulWindowedBoltExecutor<T>(bolt);
        return this.setBolt(id, new StatefulBoltExecutor<T>(executor), parallelismHint);
    }

    public BoltDeclarer setBolt(String id, SerializableBiConsumer<Tuple, BasicOutputCollector> biConsumer, String ... fields) throws IllegalArgumentException {
        return this.setBolt(id, biConsumer, (Number)null, fields);
    }

    public BoltDeclarer setBolt(String id, SerializableBiConsumer<Tuple, BasicOutputCollector> biConsumer, Number parallelismHint, String ... fields) throws IllegalArgumentException {
        return this.setBolt(id, new LambdaBiConsumerBolt(biConsumer, fields), parallelismHint);
    }

    public BoltDeclarer setBolt(String id, SerializableConsumer<Tuple> consumer) throws IllegalArgumentException {
        return this.setBolt(id, consumer, null);
    }

    public BoltDeclarer setBolt(String id, SerializableConsumer<Tuple> consumer, Number parallelismHint) throws IllegalArgumentException {
        return this.setBolt(id, new LambdaConsumerBolt(consumer), parallelismHint);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout) throws IllegalArgumentException {
        return this.setSpout(id, spout, null);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout, Number parallelismHint) throws IllegalArgumentException {
        this.validateUnusedId(id);
        this.initCommon(id, spout, parallelismHint);
        this.spouts.put(id, spout);
        return new SpoutGetter(id);
    }

    public SpoutDeclarer setSpout(String id, SerializableSupplier<?> supplier) throws IllegalArgumentException {
        return this.setSpout(id, supplier, null);
    }

    public SpoutDeclarer setSpout(String id, SerializableSupplier<?> supplier, Number parallelismHint) throws IllegalArgumentException {
        return this.setSpout(id, new LambdaSpout(supplier), parallelismHint);
    }

    public void addWorkerHook(IWorkerHook workerHook) {
        if (null == workerHook) {
            throw new IllegalArgumentException("WorkerHook must not be null.");
        }
        this.workerHooks.add(ByteBuffer.wrap(Utils.javaSerialize(workerHook)));
    }

    private void validateUnusedId(String id) {
        if (this.bolts.containsKey(id)) {
            throw new IllegalArgumentException("Bolt has already been declared for id " + id);
        }
        if (this.spouts.containsKey(id)) {
            throw new IllegalArgumentException("Spout has already been declared for id " + id);
        }
        if (this.stateSpouts.containsKey(id)) {
            throw new IllegalArgumentException("State spout has already been declared for id " + id);
        }
    }

    private void maybeAddCheckpointSpout() {
        if (this.hasStatefulBolt) {
            this.setSpout("$checkpointspout", new CheckpointSpout(), (Number)1);
        }
    }

    private void maybeAddCheckpointInputs(ComponentCommon common) {
        if (this.hasStatefulBolt) {
            this.addCheckPointInputs(common);
        }
    }

    private IRichBolt maybeAddCheckpointTupleForwarder(IRichBolt bolt) {
        if (this.hasStatefulBolt && !(bolt instanceof StatefulBoltExecutor)) {
            bolt = new CheckpointTupleForwarder(bolt);
        }
        return bolt;
    }

    private void addCheckPointInputs(ComponentCommon component) {
        HashSet<GlobalStreamId> checkPointInputs = new HashSet<GlobalStreamId>();
        for (GlobalStreamId inputStream : component.get_inputs().keySet()) {
            String sourceId = inputStream.get_componentId();
            if (this.spouts.containsKey(sourceId)) {
                checkPointInputs.add(new GlobalStreamId("$checkpointspout", "$checkpoint"));
                continue;
            }
            checkPointInputs.add(new GlobalStreamId(sourceId, "$checkpoint"));
        }
        for (GlobalStreamId streamId : checkPointInputs) {
            component.put_to_inputs(streamId, Grouping.all(new NullStruct()));
        }
    }

    private ComponentCommon getComponentCommon(String id, IComponent component) {
        ComponentCommon ret = new ComponentCommon(this.commons.get(id));
        OutputFieldsGetter getter = new OutputFieldsGetter();
        component.declareOutputFields(getter);
        ret.set_streams(getter.getFieldsDeclaration());
        return ret;
    }

    private void initCommon(String id, IComponent component, Number parallelism) throws IllegalArgumentException {
        Map<String, Object> conf;
        ComponentCommon common = new ComponentCommon();
        common.set_inputs(new HashMap<GlobalStreamId, Grouping>());
        if (parallelism != null) {
            int dop = parallelism.intValue();
            if (dop < 1) {
                throw new IllegalArgumentException("Parallelism must be positive.");
            }
            common.set_parallelism_hint(dop);
        }
        if ((conf = component.getComponentConfiguration()) != null) {
            common.set_json_conf(JSONValue.toJSONString(conf));
        }
        this.commons.put(id, common);
    }

    protected class BoltGetter
    extends ConfigGetter<BoltDeclarer>
    implements BoltDeclarer {
        private String boltId;

        public BoltGetter(String boltId) {
            super(boltId);
            this.boltId = boltId;
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, Fields fields) {
            return this.fieldsGrouping(componentId, "default", fields);
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, String streamId, Fields fields) {
            return this.grouping(componentId, streamId, Grouping.fields(fields.toList()));
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId) {
            return this.globalGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.fields(new ArrayList<String>()));
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId) {
            return this.shuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId) {
            return this.localOrShuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.local_or_shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId) {
            return this.noneGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.none(new NullStruct()));
        }

        @Override
        public BoltDeclarer allGrouping(String componentId) {
            return this.allGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer allGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.all(new NullStruct()));
        }

        @Override
        public BoltDeclarer directGrouping(String componentId) {
            return this.directGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer directGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.direct(new NullStruct()));
        }

        private BoltDeclarer grouping(String componentId, String streamId, Grouping grouping) {
            TopologyBuilder.this.commons.get(this.boltId).put_to_inputs(new GlobalStreamId(componentId, streamId), grouping);
            return this;
        }

        @Override
        public BoltDeclarer grouping(GlobalStreamId id, Grouping grouping) {
            return this.grouping(id.get_componentId(), id.get_streamId(), grouping);
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, CustomStreamGrouping grouping) {
            return this.customGrouping(componentId, "default", grouping);
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, String streamId, CustomStreamGrouping grouping) {
            return this.grouping(componentId, streamId, Grouping.custom_serialized(Utils.javaSerialize(grouping)));
        }
    }

    protected class SpoutGetter
    extends ConfigGetter<SpoutDeclarer>
    implements SpoutDeclarer {
        public SpoutGetter(String id) {
            super(id);
        }
    }

    protected class ConfigGetter<T extends ComponentConfigurationDeclarer>
    extends BaseConfigurationDeclarer<T> {
        String id;

        public ConfigGetter(String id) {
            this.id = id;
        }

        @Override
        public T addConfigurations(Map<String, Object> conf) {
            if (conf != null) {
                if (conf.containsKey("topology.kryo.register")) {
                    throw new IllegalArgumentException("Cannot set serializations for a component using fluent API");
                }
                if (!conf.isEmpty()) {
                    String currConf = TopologyBuilder.this.commons.get(this.id).get_json_conf();
                    TopologyBuilder.this.commons.get(this.id).set_json_conf(TopologyBuilder.mergeIntoJson(Utils.parseJson(currConf), conf));
                }
            }
            return (T)this;
        }

        @Override
        public Map<String, Object> getComponentConfiguration() {
            return Utils.parseJson(TopologyBuilder.this.commons.get(this.id).get_json_conf());
        }

        @Override
        public T addResources(Map<String, Double> resources) {
            if (resources != null && !resources.isEmpty()) {
                String currConf = TopologyBuilder.this.commons.get(this.id).get_json_conf();
                Map<String, Object> conf = Utils.parseJson(currConf);
                Map currentResources = (Map)conf.computeIfAbsent("topology.component.resources.map", k -> new HashMap());
                currentResources.putAll(resources);
                TopologyBuilder.this.commons.get(this.id).set_json_conf(JSONValue.toJSONString(conf));
            }
            return (T)this;
        }

        @Override
        public T addResource(String resourceName, Number resourceValue) {
            Map<String, Object> componentConf = Utils.parseJson(TopologyBuilder.this.commons.get(this.id).get_json_conf());
            Map resourcesMap = (Map)componentConf.computeIfAbsent("topology.component.resources.map", k -> new HashMap());
            resourcesMap.put(resourceName, resourceValue.doubleValue());
            return this.addConfiguration("topology.component.resources.map", resourcesMap);
        }

        @Override
        public T addSharedMemory(SharedMemory request) {
            SharedMemory found = TopologyBuilder.this.sharedMemory.get(request.get_name());
            if (found != null && !found.equals(request)) {
                throw new IllegalArgumentException("Cannot have multiple different shared memory regions with the same name");
            }
            TopologyBuilder.this.sharedMemory.put(request.get_name(), request);
            Set mems = TopologyBuilder.this.componentToSharedMemory.computeIfAbsent(this.id, k -> new HashSet());
            mems.add(request.get_name());
            return (T)this;
        }
    }
}

