/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CommonsCryptoAESDecryptor
implements Decryptor {
    private String cipherMode;
    private Properties properties;
    private Key key;
    private byte[] iv;

    public CommonsCryptoAESDecryptor(String cipherMode, Properties properties) {
        this.cipherMode = cipherMode;
        this.properties = properties;
    }

    @Override
    public void setKey(Key key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        this.key = key;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void setIv(byte[] iv) {
        Preconditions.checkNotNull((Object)iv, (Object)"IV cannot be null");
        Preconditions.checkArgument((iv.length == 16 ? 1 : 0) != 0, (Object)"Invalid IV length");
        this.iv = iv;
    }

    @Override
    public InputStream createDecryptionStream(InputStream in) {
        try {
            return new CryptoInputStream(this.cipherMode, this.properties, in, this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
    }
}

