/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metric.StormMetricsRegistry;

public class ContainerMemoryTracker {
    private final ConcurrentHashMap<Integer, TopoAndMemory> usedMemory = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, TopoAndMemory> reservedMemory = new ConcurrentHashMap();

    public ContainerMemoryTracker(StormMetricsRegistry metricsRegistry) {
        metricsRegistry.registerGauge("supervisor:current-used-memory-mb", () -> {
            Long val = this.usedMemory.values().stream().mapToLong(topoAndMem -> topoAndMem.memory).sum();
            int ret = val.intValue();
            if (val > Integer.MAX_VALUE) {
                ret = Integer.MAX_VALUE;
            }
            return ret;
        });
        metricsRegistry.registerGauge("supervisor:current-reserved-memory-mb", () -> {
            Long val = this.reservedMemory.values().stream().mapToLong(topoAndMem -> topoAndMem.memory).sum();
            int ret = val.intValue();
            if (val > Integer.MAX_VALUE) {
                ret = Integer.MAX_VALUE;
            }
            return ret;
        });
    }

    public Optional<Long> getUsedMemoryMb(int port) {
        TopoAndMemory topoAndMemory = this.usedMemory.get(port);
        if (topoAndMemory == null) {
            return Optional.empty();
        }
        return Optional.of(topoAndMemory.memory);
    }

    public long getUsedMemoryMb(String topologyId) {
        return this.usedMemory.values().stream().filter(topoAndMem -> topologyId.equals(topoAndMem.topoId)).mapToLong(topoAndMem -> topoAndMem.memory).sum();
    }

    public long getReservedMemoryMb(String topologyId) {
        return this.reservedMemory.values().stream().filter(topoAndMem -> topologyId.equals(topoAndMem.topoId)).mapToLong(topoAndMem -> topoAndMem.memory).sum();
    }

    public long getAssignedWorkerCount(String topologyId) {
        return this.usedMemory.values().stream().filter(topoAndMem -> topologyId.equals(topoAndMem.topoId)).count();
    }

    public void remove(int port) {
        this.usedMemory.remove(port);
        this.reservedMemory.remove(port);
    }

    public void setUsedMemoryMb(int port, String topologyId, long usedMemoryMb) {
        this.usedMemory.put(port, new TopoAndMemory(topologyId, usedMemoryMb));
    }

    public void setReservedMemoryMb(int port, String topologyId, long reservedMemoryMb) {
        this.reservedMemory.put(port, new TopoAndMemory(topologyId, reservedMemoryMb));
    }

    private static class TopoAndMemory {
        public final String topoId;
        public final long memory;

        TopoAndMemory(String id, long mem) {
            this.topoId = id;
            this.memory = mem;
        }

        public String toString() {
            return "{TOPO: " + this.topoId + " at " + this.memory + " MB}";
        }
    }
}

