/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.Collection;
import org.apache.storm.metric.api.DataPoint;
import org.apache.storm.metric.api.IClusterMetricsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetricsConsumerExecutor {
    public static final Logger LOG = LoggerFactory.getLogger(ClusterMetricsConsumerExecutor.class);
    private static final String ERROR_MESSAGE_PREPARATION_CLUSTER_METRICS_CONSUMER_FAILED = "Preparation of Cluster Metrics Consumer failed. Please check your configuration and/or corresponding systems and relaunch Nimbus. Skipping handle metrics.";
    private IClusterMetricsConsumer metricsConsumer;
    private String consumerClassName;
    private Object registrationArgument;

    public ClusterMetricsConsumerExecutor(String consumerClassName, Object registrationArgument) {
        this.consumerClassName = consumerClassName;
        this.registrationArgument = registrationArgument;
    }

    public void prepare() {
        try {
            this.metricsConsumer = (IClusterMetricsConsumer)Class.forName(this.consumerClassName).newInstance();
            this.metricsConsumer.prepare(this.registrationArgument);
        }
        catch (Exception e) {
            LOG.error("Could not instantiate or prepare Cluster Metrics Consumer with fully qualified name " + this.consumerClassName, (Throwable)e);
            if (this.metricsConsumer != null) {
                this.metricsConsumer.cleanup();
            }
            this.metricsConsumer = null;
        }
    }

    public void handleDataPoints(IClusterMetricsConsumer.ClusterInfo clusterInfo, Collection<DataPoint> dataPoints) {
        if (this.metricsConsumer == null) {
            LOG.error(ERROR_MESSAGE_PREPARATION_CLUSTER_METRICS_CONSUMER_FAILED);
            return;
        }
        try {
            this.metricsConsumer.handleDataPoints(clusterInfo, dataPoints);
        }
        catch (Throwable e) {
            LOG.error("Error while handling cluster data points, consumer class: " + this.consumerClassName, e);
        }
    }

    public void handleDataPoints(IClusterMetricsConsumer.SupervisorInfo supervisorInfo, Collection<DataPoint> dataPoints) {
        if (this.metricsConsumer == null) {
            LOG.error(ERROR_MESSAGE_PREPARATION_CLUSTER_METRICS_CONSUMER_FAILED);
            return;
        }
        try {
            this.metricsConsumer.handleDataPoints(supervisorInfo, dataPoints);
        }
        catch (Throwable e) {
            LOG.error("Error while handling cluster data points, consumer class: " + this.consumerClassName, e);
        }
    }

    public void cleanup() {
        if (this.metricsConsumer != null) {
            this.metricsConsumer.cleanup();
        }
    }
}

