/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.common.spi.ServerAdapter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyServerAdapter
implements ServerAdapter {
    Request request;
    Response response;

    public JettyServerAdapter(Request jettyRequest, Response jettyResponse) {
        this.request = jettyRequest;
        this.response = jettyResponse;
    }

    public long getContentLength() {
        return this.response.getContentCount();
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public long getRequestTimestamp() {
        return this.request.getTimeStamp();
    }

    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        HttpFields.Mutable httpFields = this.response.getHttpFields();
        Enumeration e = httpFields.getFieldNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.response.getHeader(key);
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

