/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.common;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Map;
import org.apache.storm.daemon.ui.UIHelpers;

public class JsonResponseBuilder {
    private Object data;
    private String callback;
    private boolean needSerialize = true;
    private int status = 200;
    private Map<String, Object> headers = Collections.emptyMap();

    public JsonResponseBuilder setData(Object data) {
        this.data = data;
        return this;
    }

    public JsonResponseBuilder setCallback(String callback) {
        this.callback = callback;
        return this;
    }

    public JsonResponseBuilder setNeedSerialize(boolean needSerialize) {
        this.needSerialize = needSerialize;
        return this;
    }

    public JsonResponseBuilder setStatus(int status) {
        this.status = status;
        return this;
    }

    public JsonResponseBuilder setHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public Response build() {
        String body = UIHelpers.getJsonResponseBody(this.data, this.callback, this.needSerialize);
        Map respHeaders = UIHelpers.getJsonResponseHeaders(this.callback, this.headers);
        Response.ResponseBuilder respBuilder = Response.status((int)this.status).entity((Object)body);
        respHeaders.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)respBuilder).header(arg_0, arg_1));
        return respBuilder.build();
    }
}

