/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalTimeSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class LocalDateTimeSerializer
extends TypeSerializerSingleton<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public LocalDateTime createInstance() {
        return LocalDateTime.of(LocalDateSerializer.INSTANCE.createInstance(), LocalTimeSerializer.INSTANCE.createInstance());
    }

    @Override
    public LocalDateTime copy(LocalDateTime from) {
        return from;
    }

    @Override
    public LocalDateTime copy(LocalDateTime from, LocalDateTime reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return LocalDateSerializer.INSTANCE.getLength() + LocalTimeSerializer.INSTANCE.getLength();
    }

    @Override
    public void serialize(LocalDateTime record, DataOutputView target) throws IOException {
        if (record == null) {
            LocalDateSerializer.INSTANCE.serialize(null, target);
            LocalTimeSerializer.INSTANCE.serialize(null, target);
        } else {
            LocalDateSerializer.INSTANCE.serialize(record.toLocalDate(), target);
            LocalTimeSerializer.INSTANCE.serialize(record.toLocalTime(), target);
        }
    }

    @Override
    public LocalDateTime deserialize(DataInputView source) throws IOException {
        LocalDate localDate = LocalDateSerializer.INSTANCE.deserialize(source);
        LocalTime localTime = LocalTimeSerializer.INSTANCE.deserialize(source);
        if (localDate == null && localTime == null) {
            return null;
        }
        if (localDate == null || localTime == null) {
            throw new IOException("Exactly one of LocalDate and LocalTime is null.");
        }
        return LocalDateTime.of(localDate, localTime);
    }

    @Override
    public LocalDateTime deserialize(LocalDateTime reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        LocalDateSerializer.INSTANCE.copy(source, target);
        LocalTimeSerializer.INSTANCE.copy(source, target);
    }

    @Override
    public TypeSerializerSnapshot<LocalDateTime> snapshotConfiguration() {
        return new LocalDateTimeSerializerSnapshot();
    }

    public static final class LocalDateTimeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<LocalDateTime> {
        public LocalDateTimeSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

