/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.visitor.RutaInferenceVisitor;

public class TimeProfilerVisitor
implements RutaInferenceVisitor {
    private Map<RutaElement, Long> timeInfo = new HashMap<RutaElement, Long>();

    @Override
    public void beginVisit(RutaElement element, ScriptApply result) {
        this.getTimeInfo().put(element, System.currentTimeMillis());
    }

    @Override
    public void endVisit(RutaElement element, ScriptApply result) {
        Long start = this.getTimeInfo().get(element);
        long value = System.currentTimeMillis() - start;
        this.getTimeInfo().put(element, value);
    }

    @Override
    public void finished(RutaStream stream, List<RutaInferenceVisitor> visitors) {
    }

    public Map<RutaElement, Long> getTimeInfo() {
        return this.timeInfo;
    }

    @Override
    public void annotationAdded(AnnotationFS annotation, AbstractRuleMatch<? extends AbstractRule> creator) {
    }
}

