/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.instrument.Instrumentation;
import java.util.Properties;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

public class LightstreamerDetector
extends AbstractServerDetector {
    private static final String[] SYSTEM_PROERTY_NAMES = new String[]{"com.lightstreamer.internal_lib_path", "com.lightstreamer.kernel_lib_path", "com.lightstreamer.logging_lib_path", "com.lightstreamer.database_lib_path"};
    private static final int LIGHTSTREAMER_DETECT_TIMEOUT = 300000;
    private static final int LIGHTSTREAMER_DETECT_INTERVAL = 200;
    private static final int LIGHTSTREAMER_DETECT_FINAL_DELAY = 500;
    private static final String LIGHTSTREAMER_MBEAN_CLASS = "com.lightstreamer.jmx.ServerMBean";

    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String serverVersion = this.getSingleStringAttribute(pMBeanServerExecutor, "com.lightstreamer:type=Server", "LSVersion");
        if (serverVersion != null) {
            return new ServerHandle("LightStreamer", "LightStreamer", serverVersion, null);
        }
        return null;
    }

    @Override
    public void jvmAgentStartup(Instrumentation instrumentation) {
        if (this.isLightStreamer(instrumentation)) {
            this.awaitLightstreamerMBeans(instrumentation);
        }
    }

    protected boolean isLightStreamer(Instrumentation instrumentation) {
        Properties systemProperties = System.getProperties();
        for (String expectedPropertyName : SYSTEM_PROERTY_NAMES) {
            if (!systemProperties.containsKey(expectedPropertyName)) continue;
            return true;
        }
        return false;
    }

    private void awaitLightstreamerMBeans(Instrumentation instrumentation) {
        int count = 0;
        while (count * 200 < 300000) {
            boolean serverMBean = this.isClassLoaded(LIGHTSTREAMER_MBEAN_CLASS, instrumentation);
            if (serverMBean) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            try {
                Thread.sleep(200L);
                ++count;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException(String.format("Detected Lightstreamer, but JMX MBeans were not loaded after %d seconds", 300));
    }
}

