/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import java.util.Set;
import org.apache.activemq.management.MessageFlowStats;
import org.apache.activemq.management.Resettable;
import org.apache.activemq.management.Statistic;
import org.apache.activemq.management.UnsampledStatistic;
import org.apache.activemq.management.UnsampledStatisticImpl;
import org.apache.activemq.management.UnsampledStatsImpl;

public class MessageFlowStatsImpl
extends UnsampledStatsImpl
implements MessageFlowStats,
Statistic,
Resettable {
    private final UnsampledStatisticImpl<Long> enqueuedMessageBrokerInTime = new UnsampledStatisticImpl<Long>("enqueuedMessageBrokerInTime", "ms", "Broker in time (ms) of last enqueued message to the destination", 0L);
    private final UnsampledStatisticImpl<String> enqueuedMessageClientID = new UnsampledStatisticImpl<Object>("enqueuedMessageClientID", "id", "ClientID of last enqueued message to the destination", null);
    private final UnsampledStatisticImpl<String> enqueuedMessageID = new UnsampledStatisticImpl<Object>("enqueuedMessageID", "id", "MessageID of last enqueued message to the destination", null);
    private final UnsampledStatisticImpl<Long> enqueuedMessageTimestamp = new UnsampledStatisticImpl<Long>("enqueuedMessageTimestamp", "ms", "Message timestamp of last enqueued message to the destination", 0L);
    private final UnsampledStatisticImpl<Long> dequeuedMessageBrokerInTime = new UnsampledStatisticImpl<Long>("dequeuedMessageBrokerInTime", "ms", "Broker in time (ms) of last dequeued message to the destination", 0L);
    private final UnsampledStatisticImpl<Long> dequeuedMessageBrokerOutTime = new UnsampledStatisticImpl<Long>("dequeuedMessageBrokerOutTime", "ms", "Broker out time (ms) of last dequeued message to the destination", 0L);
    private final UnsampledStatisticImpl<String> dequeuedMessageClientID = new UnsampledStatisticImpl<Object>("dequeuedMessageClientID", "id", "ClientID of last dequeued message to the destination", null);
    private final UnsampledStatisticImpl<String> dequeuedMessageID = new UnsampledStatisticImpl<Object>("dequeuedMessageID", "id", "MessageID of last dequeued message to the destination", null);
    private final UnsampledStatisticImpl<Long> dequeuedMessageTimestamp = new UnsampledStatisticImpl<Long>("dequeuedMessageTimestamp", "ms", "Message timestamp of last dequeued message to the destination", 0L);

    public MessageFlowStatsImpl() {
        this.addStatistics(Set.of(this.enqueuedMessageBrokerInTime, this.enqueuedMessageClientID, this.enqueuedMessageID, this.enqueuedMessageTimestamp, this.dequeuedMessageBrokerInTime, this.dequeuedMessageBrokerOutTime, this.dequeuedMessageClientID, this.dequeuedMessageID, this.dequeuedMessageTimestamp));
    }

    @Override
    public UnsampledStatistic<Long> getEnqueuedMessageBrokerInTime() {
        return this.enqueuedMessageBrokerInTime;
    }

    @Override
    public UnsampledStatistic<String> getEnqueuedMessageClientID() {
        return this.enqueuedMessageClientID;
    }

    @Override
    public UnsampledStatistic<String> getEnqueuedMessageID() {
        return this.enqueuedMessageID;
    }

    @Override
    public UnsampledStatistic<Long> getEnqueuedMessageTimestamp() {
        return this.enqueuedMessageTimestamp;
    }

    @Override
    public UnsampledStatistic<Long> getDequeuedMessageBrokerInTime() {
        return this.dequeuedMessageBrokerInTime;
    }

    @Override
    public UnsampledStatistic<Long> getDequeuedMessageBrokerOutTime() {
        return this.dequeuedMessageBrokerOutTime;
    }

    @Override
    public UnsampledStatistic<String> getDequeuedMessageClientID() {
        return this.dequeuedMessageClientID;
    }

    @Override
    public UnsampledStatistic<String> getDequeuedMessageID() {
        return this.dequeuedMessageID;
    }

    @Override
    public UnsampledStatistic<Long> getDequeuedMessageTimestamp() {
        return this.dequeuedMessageTimestamp;
    }

    @Override
    public synchronized void enqueueStats(String clientID, String messageID, long messageTimestamp, long messageBrokerInTime) {
        this.enqueuedMessageClientID.setValue(clientID);
        this.enqueuedMessageID.setValue(messageID);
        this.enqueuedMessageTimestamp.setValue(messageTimestamp);
        this.enqueuedMessageBrokerInTime.setValue(messageBrokerInTime);
    }

    @Override
    public synchronized void dequeueStats(String clientID, String messageID) {
        this.dequeuedMessageClientID.setValue(clientID);
        this.dequeuedMessageID.setValue(messageID);
    }

    @Override
    public synchronized void dequeueStats(String clientID, String messageID, long messageTimestamp, long messageBrokerInTime, long messageBrokerOutTime) {
        this.dequeuedMessageClientID.setValue(clientID);
        this.dequeuedMessageID.setValue(messageID);
        this.dequeuedMessageTimestamp.setValue(messageTimestamp);
        this.dequeuedMessageBrokerInTime.setValue(messageBrokerInTime);
        this.dequeuedMessageBrokerOutTime.setValue(messageBrokerOutTime);
    }
}

