/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InstallAbstract;
import org.apache.activemq.artemis.cli.commands.util.HashUtil;
import org.apache.activemq.artemis.cli.commands.util.SyncCalculation;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioFile;
import org.apache.activemq.artemis.utils.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a new broker instance."})
public class Create
extends InstallAbstract {
    private static final Integer DEFAULT_PORT = 61616;
    private static final Integer AMQP_PORT = 5672;
    private static final Integer STOMP_PORT = 61613;
    private static final Integer HQ_PORT = 5445;
    public static final String HTTP_HOST = "localhost";
    public static final Integer HTTP_PORT = 8161;
    private static final Integer MQTT_PORT = 1883;
    public static final String ARTEMIS_CMD = "artemis.cmd";
    public static final String BIN_ARTEMIS_CMD = "bin/artemis.cmd";
    public static final String ARTEMIS_SERVICE_EXE = "artemis-service.exe";
    public static final String BIN_ARTEMIS_SERVICE_EXE = "bin/artemis-service.exe";
    public static final String ARTEMIS_SERVICE_EXE_CONFIG = "artemis-service.exe.config";
    public static final String BIN_ARTEMIS_SERVICE_EXE_CONFIG = "bin/artemis-service.exe.config";
    public static final String ARTEMIS_SERVICE_XML = "artemis-service.xml";
    public static final String BIN_ARTEMIS_SERVICE_XML = "bin/artemis-service.xml";
    public static final String ETC_ARTEMIS_PROFILE_CMD = "artemis.profile.cmd";
    public static final String ETC_ARTEMIS_UTILITY_PROFILE_CMD = "artemis-utility.profile.cmd";
    public static final String ARTEMIS = "artemis";
    public static final String BIN_ARTEMIS = "bin/artemis";
    public static final String ARTEMIS_SERVICE = "artemis-service";
    public static final String BIN_ARTEMIS_SERVICE = "bin/artemis-service";
    public static final String ETC_ARTEMIS_PROFILE = "artemis.profile";
    public static final String ETC_ARTEMIS_UTILITY_PROFILE = "artemis-utility.profile";
    public static final String ETC_LOG4J2_PROPERTIES = "log4j2.properties";
    public static final String ETC_LOG4J2_UTILITY_PROPERTIES = "log4j2-utility.properties";
    public static final String ETC_BOOTSTRAP_XML = "bootstrap.xml";
    public static final String ETC_MANAGEMENT_XML = "management.xml";
    public static final String ETC_BROKER_XML = "broker.xml";
    public static final String ETC_ARTEMIS_ROLES_PROPERTIES = "artemis-roles.properties";
    public static final String ETC_ARTEMIS_USERS_PROPERTIES = "artemis-users.properties";
    private static final String ETC_LOGIN_CONFIG = "login.config";
    private static final String ETC_LOGIN_CONFIG_WITH_GUEST = "etc/login-with-guest.config";
    private static final String ETC_LOGIN_CONFIG_WITHOUT_GUEST = "etc/login-without-guest.config";
    public static final String ETC_REPLICATED_PRIMARY_SETTINGS_TXT = "etc/replicated-primary-settings.txt";
    public static final String ETC_REPLICATED_BACKUP_SETTINGS_TXT = "etc/replicated-backup-settings.txt";
    public static final String ETC_SHARED_STORE_SETTINGS_TXT = "etc/shared-store-settings.txt";
    public static final String ETC_CLUSTER_SECURITY_SETTINGS_TXT = "etc/cluster-security-settings.txt";
    public static final String ETC_CLUSTER_SETTINGS_TXT = "etc/cluster-settings.txt";
    public static final String ETC_CLUSTER_STATIC_SETTINGS_TXT = "etc/cluster-static-settings.txt";
    public static final String ETC_CONNECTOR_SETTINGS_TXT = "etc/connector-settings.txt";
    public static final String ETC_BOOTSTRAP_WEB_SETTINGS_TXT = "etc/bootstrap-web-settings.txt";
    public static final String ETC_JOURNAL_BUFFER_SETTINGS = "etc/journal-buffer-settings.txt";
    public static final String ETC_AMQP_ACCEPTOR_TXT = "etc/amqp-acceptor.txt";
    public static final String ETC_HORNETQ_ACCEPTOR_TXT = "etc/hornetq-acceptor.txt";
    public static final String ETC_MQTT_ACCEPTOR_TXT = "etc/mqtt-acceptor.txt";
    public static final String ETC_STOMP_ACCEPTOR_TXT = "etc/stomp-acceptor.txt";
    public static final String ETC_PING_TXT = "etc/ping-settings.txt";
    public static final String ETC_COMMENTED_PING_TXT = "etc/commented-ping-settings.txt";
    public static final String ETC_DATABASE_STORE_TXT = "etc/database-store.txt";
    public static final String ETC_JAAS_SECURITY_MANAGER_TXT = "etc/jaas-security-manager.txt";
    public static final String ETC_BASIC_SECURITY_MANAGER_TXT = "etc/basic-security-manager.txt";
    public static final String ETC_GLOBAL_MAX_SPECIFIED_TXT = "etc/global-max-specified.txt";
    public static final String ETC_GLOBAL_MAX_DEFAULT_TXT = "etc/global-max-default.txt";
    public static final String ETC_PAGE_SYNC_SETTINGS = "etc/page-sync-settings.txt";
    public static final String ETC_JOLOKIA_ACCESS_XML = "jolokia-access.xml";
    @CommandLine.Option(names={"--host"}, description={"Broker's host name. Default: 0.0.0.0 or input if clustered)."})
    private String host;
    @CommandLine.Option(names={"--http-host"}, description={"Embedded web server's host name. Default: localhost."})
    private String httpHost = "localhost";
    @CommandLine.Option(names={"--relax-jolokia"}, description={"Disable strict checking in jolokia-access.xml."})
    private boolean relaxJolokia;
    @CommandLine.Option(names={"--ping"}, description={"A comma separated string to be passed on to the broker config as network-check-list. The broker will shutdown when all these addresses are unreachable."})
    private String ping;
    @CommandLine.Option(names={"--default-port"}, description={"The port number to use for the main 'artemis' acceptor. Default: 61616."})
    private int defaultPort = DEFAULT_PORT;
    @CommandLine.Option(names={"--http-port"}, description={"Embedded web server's port. Default: 8161."})
    private int httpPort = HTTP_PORT;
    @CommandLine.Option(names={"--ssl-key"}, description={"Embedded web server's key store path."})
    private String sslKey;
    @CommandLine.Option(names={"--ssl-key-password"}, description={"The key store's password."})
    private String sslKeyPassword;
    @CommandLine.Option(names={"--use-client-auth"}, description={"Require client certificate authentication when connecting to the embedded web server."})
    private boolean useClientAuth;
    @CommandLine.Option(names={"--ssl-trust"}, description={"The trust store path in case of client authentication."})
    private String sslTrust;
    @CommandLine.Option(names={"--ssl-trust-password"}, description={"The trust store's password."})
    private String sslTrustPassword;
    @CommandLine.Option(names={"--name"}, description={"The name of the broker. Default: same as host name."})
    private String name;
    @CommandLine.Option(names={"--port-offset"}, description={"How much to off-set the ports of every acceptor."})
    private int portOffset;
    @CommandLine.Option(names={"--force"}, description={"Overwrite configuration at destination directory."})
    private boolean force;
    @CommandLine.Option(names={"--purge-page-folders"}, description={"Paged folders should be removed upon leaving page state."})
    private boolean purgePageFolders;
    @CommandLine.Option(names={"--clustered"}, description={"Enable clustering."})
    private boolean clustered = false;
    @CommandLine.Option(names={"--max-hops"}, description={"Number of hops on the cluster configuration."})
    private int maxHops = 0;
    @CommandLine.Option(names={"--message-load-balancing"}, description={"Message load balancing policy for cluster. Default: ON_DEMAND. Valid values: ON_DEMAND, STRICT, OFF, OFF_WITH_REDISTRIBUTION."})
    private MessageLoadBalancingType messageLoadBalancing = MessageLoadBalancingType.ON_DEMAND;
    @CommandLine.Option(names={"--replicated"}, description={"Enable broker replication."})
    private boolean replicated = false;
    @CommandLine.Option(names={"--shared-store"}, description={"Enable broker shared store."})
    private boolean sharedStore = false;
    @Deprecated(forRemoval=true)
    @CommandLine.Option(names={"--slave"}, description={"Deprecated for removal. Use 'backup' instead."}, hidden=true)
    private boolean slave;
    @CommandLine.Option(names={"--backup"}, description={"Be a backup broker. Valid for shared store or replication."})
    private boolean backup;
    @CommandLine.Option(names={"--failover-on-shutdown"}, description={"Whether broker shutdown will trigger failover for clients using the core protocol. Valid only for shared store. Default: false."})
    private boolean failoverOnShutodwn;
    @CommandLine.Option(names={"--cluster-user"}, description={"The user to use for clustering. Default: input."})
    private String clusterUser = null;
    @CommandLine.Option(names={"--cluster-password"}, description={"The password to use for clustering. Default: input."})
    private String clusterPassword = null;
    @CommandLine.Option(names={"--allow-anonymous"}, description={"Allow connections from users with no security credentials. Opposite of --require-login. Default: input."})
    private Boolean allowAnonymous = null;
    @CommandLine.Option(names={"--require-login"}, description={"Require security credentials from users for connection. Opposite of --allow-anonymous."})
    private Boolean requireLogin = null;
    @CommandLine.Option(names={"--paging"}, description={"Page messages to disk when address becomes full. Opposite of --blocking. Default: true."})
    private Boolean paging;
    @CommandLine.Option(names={"--blocking"}, description={"Block producers when address becomes full. Opposite of --paging. Default: false."})
    private Boolean blocking;
    @CommandLine.Option(names={"--no-autotune"}, description={"Disable auto tuning of the journal-buffer-timeout in broker.xml."})
    private boolean noAutoTune;
    @CommandLine.Option(names={"--no-autocreate"}, description={"Disable auto creation for addresses & queues."})
    private Boolean noAutoCreate;
    @CommandLine.Option(names={"--autocreate"}, description={"Allow automatic creation of addresses & queues. Default: true."})
    private Boolean autoCreate;
    @CommandLine.Option(names={"--autodelete"}, description={"Allow automatic deletion of addresses & queues. Default: false."})
    private boolean autoDelete;
    @CommandLine.Option(names={"--user"}, description={"The username. Default: input."})
    private String user;
    @CommandLine.Option(names={"--password"}, description={"The user's password. Default: input."})
    private String password;
    @CommandLine.Option(names={"--role"}, description={"The name for the role created. Default: amq."})
    private String role = "amq";
    @CommandLine.Option(names={"--no-web"}, description={"Whether to omit the web-server definition from bootstrap.xml."})
    private boolean noWeb;
    @CommandLine.Option(names={"--queues"}, description={"A comma separated list of queues with the option to specify a routing type, e.g. --queues myQueue1,myQueue2:multicast. Routing-type default: anycast."})
    private String queues;
    @CommandLine.Option(names={"--addresses"}, description={"A comma separated list of addresses with the option to specify a routing type, e.g. --addresses myAddress1,myAddress2:anycast. Routing-type default: multicast."})
    private String addresses;
    @CommandLine.Option(names={"--aio"}, description={"Set the journal as asyncio."})
    private boolean aio;
    @CommandLine.Option(names={"--nio"}, description={"Set the journal as nio."})
    private boolean nio;
    @CommandLine.Option(names={"--mapped"}, description={"Set the journal as mapped."})
    private boolean mapped;
    private JournalType journalType;
    @CommandLine.Option(names={"--disable-persistence"}, description={"Disable message persistence to the journal"})
    private boolean disablePersistence;
    @CommandLine.Option(names={"--no-amqp-acceptor"}, description={"Disable the AMQP specific acceptor."})
    private boolean noAmqpAcceptor;
    @CommandLine.Option(names={"--no-mqtt-acceptor"}, description={"Disable the MQTT specific acceptor."})
    private boolean noMqttAcceptor;
    @CommandLine.Option(names={"--no-stomp-acceptor"}, description={"Disable the STOMP specific acceptor."})
    private boolean noStompAcceptor;
    @CommandLine.Option(names={"--no-hornetq-acceptor"}, description={"Disable the HornetQ specific acceptor."})
    private boolean noHornetQAcceptor;
    @CommandLine.Option(names={"--no-fsync"}, description={"Disable usage of fdatasync (channel.force(false) from Java NIO) on the journal."})
    private boolean noJournalSync;
    @CommandLine.Option(names={"--journal-device-block-size"}, description={"The block size of the journal's storage device. Default: 4096."})
    private int journalDeviceBlockSize = 4096;
    @CommandLine.Option(names={"--journal-retention"}, description={"Configure journal retention in days. If > 0 then enable journal-retention-directory from broker.xml allowing replay options."})
    private int retentionDays;
    @CommandLine.Option(names={"--journal-retention-max-bytes"}, description={"Maximum number of bytes to keep in the retention directory."})
    private String retentionMaxBytes;
    @CommandLine.Option(names={"--global-max-size"}, description={"Maximum amount of memory which message data may consume. Default: half of the JVM's max memory."})
    private String globalMaxSize;
    @CommandLine.Option(names={"--global-max-messages"}, description={"Maximum number of messages that will be accepted in memory before using address full policy mode. Default: undefined."})
    private long globalMaxMessages = -1L;
    @CommandLine.Option(names={"--jdbc"}, description={"Store message data in JDBC instead of local files."})
    boolean jdbc;
    @CommandLine.Option(names={"--staticCluster", "--static-cluster"}, description={"Cluster node connectors list separated by comma, e.g. \"tcp://server:61616,tcp://server2:61616,tcp://server3:61616\"."})
    String staticNode;
    @CommandLine.Option(names={"--support-advisory"}, description={"Support advisory messages for the OpenWire protocol."})
    boolean supportAdvisory = false;
    @CommandLine.Option(names={"--suppress-internal-management-objects"}, description={"Do not register any advisory addresses/queues for the OpenWire protocol with the broker's management service."})
    boolean suppressInternalManagementObjects = false;
    @CommandLine.Option(names={"--security-manager"}, description={"Which security manager to use - jaas or basic. Default: jaas."})
    private String securityManager = "jaas";
    @CommandLine.Option(names={"--journal-max-io"}, description={"The journal-max-io value to use when also using the ASYNCIO journal-type. When using NIO or MAPPED this value is always '1'. Default: 4096"})
    private int journalMaxIo = ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio();
    @CommandLine.Option(names={"--jdbc-bindings-table-name"}, description={"Name of the jdbc bindings table."})
    private String jdbcBindings = ActiveMQDefaultConfiguration.getDefaultBindingsTableName();
    @CommandLine.Option(names={"--jdbc-message-table-name"}, description={"Name of the jdbc messages table."})
    private String jdbcMessages = ActiveMQDefaultConfiguration.getDefaultMessageTableName();
    @CommandLine.Option(names={"--jdbc-large-message-table-name"}, description={"Name of the large messages table."})
    private String jdbcLargeMessages = ActiveMQDefaultConfiguration.getDefaultLargeMessagesTableName();
    @CommandLine.Option(names={"--jdbc-page-store-table-name"}, description={"Name of the page store messages table."})
    private String jdbcPageStore = ActiveMQDefaultConfiguration.getDefaultPageStoreTableName();
    @CommandLine.Option(names={"--jdbc-node-manager-table-name"}, description={"Name of the jdbc node manager table."})
    private String jdbcNodeManager = ActiveMQDefaultConfiguration.getDefaultNodeManagerStoreTableName();
    @CommandLine.Option(names={"--jdbc-connection-url"}, description={"The URL used for the database connection."})
    private String jdbcURL = null;
    @CommandLine.Option(names={"--jdbc-driver-class-name"}, description={"JDBC driver classname."})
    private String jdbcClassName = ActiveMQDefaultConfiguration.getDefaultDriverClassName();
    @CommandLine.Option(names={"--jdbc-network-timeout"}, description={"Network timeout (in milliseconds)."})
    long jdbcNetworkTimeout = ActiveMQDefaultConfiguration.getDefaultJdbcNetworkTimeout();
    @CommandLine.Option(names={"--jdbc-lock-renew-period"}, description={"Lock Renew Period (in milliseconds)."})
    long jdbcLockRenewPeriod = ActiveMQDefaultConfiguration.getDefaultJdbcLockRenewPeriodMillis();
    @CommandLine.Option(names={"--jdbc-lock-expiration"}, description={"Lock expiration (in milliseconds)."})
    long jdbcLockExpiration = ActiveMQDefaultConfiguration.getDefaultJdbcLockExpirationMillis();

    public String[] getStaticNodes() {
        if (this.staticNode == null) {
            return new String[0];
        }
        return this.staticNode.split(",");
    }

    private boolean isAutoCreate() {
        if (this.autoCreate == null && this.noAutoCreate != null) {
            this.autoCreate = this.noAutoCreate == false;
        }
        if (this.autoCreate == null) {
            this.autoCreate = true;
        }
        return this.autoCreate;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = "0.0.0.0";
        }
        return this.host;
    }

    private String getHostForClustered() {
        if (this.getHost().equals("0.0.0.0")) {
            this.host = this.input("--host", "Host " + this.host + " is not valid for clustering. Please provide a valid IP or hostname", HTTP_HOST);
        }
        return this.host;
    }

    public boolean isPurgePageFolders() {
        return this.purgePageFolders;
    }

    public void setPurgePageFolders(boolean purgePageFolders) {
        this.purgePageFolders = purgePageFolders;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    public boolean isSharedStore() {
        return this.sharedStore;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getEtc() {
        return this.etc;
    }

    public void setEtc(String etc) {
        this.etc = etc;
    }

    protected void setNoAutoTune(boolean autTune) {
        this.noAutoTune = autTune;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    protected void setHttpHost(String httpHost) {
        this.httpHost = httpHost;
    }

    protected void setRelaxJolokia(boolean relaxJolokia) {
        this.relaxJolokia = relaxJolokia;
    }

    public Create setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    private String getClusterUser() {
        if (this.clusterUser == null) {
            this.clusterUser = this.input("--cluster-user", "What is the cluster user?", "cluster-admin");
        }
        return this.clusterUser;
    }

    private String getClusterPassword() {
        if (this.clusterPassword == null) {
            this.clusterPassword = this.inputPassword("--cluster-password", "What is the cluster password?", "password-admin");
        }
        return this.clusterPassword;
    }

    private String getSslKeyPassword() {
        if (this.sslKeyPassword == null) {
            this.sslKeyPassword = this.inputPassword("--ssl-key-password", "What is the keystore password?", "password");
        }
        return this.sslKeyPassword;
    }

    private String getSslTrust() {
        if (this.sslTrust == null) {
            this.sslTrust = this.input("--ssl-trust", "What is the trust store path?", "/etc/truststore.jks");
        }
        return this.sslTrust;
    }

    private String getSslTrustPassword() {
        if (this.sslTrustPassword == null) {
            this.sslTrustPassword = this.inputPassword("--ssl-key-password", "What is the keystore password?", "password");
        }
        return this.sslTrustPassword;
    }

    private boolean isAllowAnonymous() {
        if (this.allowAnonymous == null) {
            this.allowAnonymous = this.inputBoolean("--allow-anonymous | --require-login", "Allow anonymous access?", true);
        }
        return this.allowAnonymous;
    }

    public boolean isPaging() {
        return this.paging;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.inputPassword("--password", "What is the default password?", "admin");
        }
        this.password = HashUtil.tryHash(this.getActionContext(), this.password);
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = this.input("--user", "What is the default username?", "admin");
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int getJournalMaxIo() {
        return this.journalMaxIo;
    }

    public void setJournalMaxIo(int journalMaxIo) {
        this.journalMaxIo = journalMaxIo;
    }

    public boolean isAio() {
        return this.aio;
    }

    public void setAio(boolean aio) {
        this.aio = aio;
    }

    public boolean isNio() {
        return this.nio;
    }

    public void setNio(boolean nio) {
        this.nio = nio;
    }

    private boolean isBackup() {
        return this.slave || this.backup;
    }

    private boolean isFailoverOnShutodwn() {
        return this.failoverOnShutodwn;
    }

    private boolean isDisablePersistence() {
        return this.disablePersistence;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.checkDirectory();
        super.execute(context);
        return this.run(context);
    }

    private void checkDirectory() {
        if (!this.directory.exists()) {
            boolean created = this.directory.mkdirs();
            if (!created) {
                throw new RuntimeException(String.format("Unable to create the path '%s'.", this.directory));
            }
        } else if (!this.directory.canWrite()) {
            throw new RuntimeException(String.format("The path '%s' is not writable.", this.directory));
        }
    }

    private File createDirectory(String name, File root) {
        File directory = new File(name);
        if (!directory.isAbsolute()) {
            directory = new File(root, name);
        }
        directory.mkdirs();
        return directory;
    }

    @Override
    public Object run(ActionContext context) throws Exception {
        super.run(context);
        this.setupJournalType();
        if (this.requireLogin != null && this.requireLogin.booleanValue()) {
            this.allowAnonymous = Boolean.FALSE;
        }
        context.out.println(String.format("Creating ActiveMQ Artemis instance at: %s", this.directory.getCanonicalPath()));
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        if (this.journalDeviceBlockSize % 512 != 0) {
            throw new IllegalArgumentException("The device-block-size must be a multiple of 512");
        }
        filters.put("${device-block-size}", Integer.toString(this.journalDeviceBlockSize));
        filters.put("${primary-backup}", this.isBackup() ? "backup" : "primary");
        filters.put("${failover-on-shutdown}", this.isFailoverOnShutodwn() ? "true" : "false");
        filters.put("${persistence-enabled}", this.isDisablePersistence() ? "false" : "true");
        filters.put("${purge-page-folders}", this.isPurgePageFolders() ? "true" : "false");
        if (this.ping != null && !this.ping.isEmpty()) {
            filters.put("${ping}", this.ping);
            filters.put("${ping-config.settings}", Create.readTextFile(ETC_PING_TXT, filters));
        } else {
            filters.put("${ping-config.settings}", Create.readTextFile(ETC_COMMENTED_PING_TXT, filters));
        }
        if (this.staticNode != null) {
            this.clustered = true;
        }
        if (this.replicated) {
            this.clustered = true;
            filters.put("${replicated.settings}", Create.readTextFile(this.isBackup() ? ETC_REPLICATED_BACKUP_SETTINGS_TXT : ETC_REPLICATED_PRIMARY_SETTINGS_TXT, filters));
        } else {
            filters.put("${replicated.settings}", "");
        }
        if (this.sharedStore) {
            this.clustered = true;
            filters.put("${shared-store.settings}", Create.readTextFile(ETC_SHARED_STORE_SETTINGS_TXT, filters));
        } else {
            filters.put("${shared-store.settings}", "");
        }
        filters.put("${journal.settings}", this.journalType.name());
        if (this.sslKey != null) {
            filters.put("${web.protocol}", "https");
            this.getSslKeyPassword();
            String extraWebAttr = " keyStorePath=\"" + this.sslKey + "\" keyStorePassword=\"" + this.sslKeyPassword + "\"";
            if (this.useClientAuth) {
                this.getSslTrust();
                this.getSslTrustPassword();
                extraWebAttr = extraWebAttr + " clientAuth=\"true\" trustStorePath=\"" + this.sslTrust + "\" trustStorePassword=\"" + this.sslTrustPassword + "\"";
            }
            filters.put("${extra.web.attributes}", extraWebAttr);
        } else {
            filters.put("${web.protocol}", "http");
            filters.put("${extra.web.attributes}", "");
        }
        filters.put("${fsync}", String.valueOf(!this.noJournalSync));
        filters.put("${default.port}", String.valueOf(this.defaultPort + this.portOffset));
        filters.put("${support-advisory}", Boolean.toString(this.supportAdvisory));
        filters.put("${suppress-internal-management-objects}", Boolean.toString(this.suppressInternalManagementObjects));
        filters.put("${amqp.port}", String.valueOf(AMQP_PORT + this.portOffset));
        filters.put("${stomp.port}", String.valueOf(STOMP_PORT + this.portOffset));
        filters.put("${hq.port}", String.valueOf(HQ_PORT + this.portOffset));
        filters.put("${mqtt.port}", String.valueOf(MQTT_PORT + this.portOffset));
        filters.put("${http.host}", this.httpHost);
        filters.put("${http.port}", String.valueOf(this.httpPort + this.portOffset));
        filters.put("${data.dir}", this.data);
        filters.put("${max-hops}", String.valueOf(this.maxHops));
        filters.put("${message-load-balancing}", this.messageLoadBalancing.toString());
        filters.put("${user}", this.getUser());
        filters.put("${password}", this.getPassword());
        filters.put("${encoded.role}", this.role.replaceAll(" ", "\\\\ "));
        filters.put("${global-max-messages}", Long.toString(this.globalMaxMessages));
        if (this.globalMaxSize == null || this.globalMaxSize.trim().isEmpty()) {
            filters.put("${global-max-section}", Create.readTextFile(ETC_GLOBAL_MAX_DEFAULT_TXT, filters));
        } else {
            filters.put("${global-max-size}", this.globalMaxSize);
            filters.put("${global-max-section}", Create.readTextFile(ETC_GLOBAL_MAX_SPECIFIED_TXT, filters));
        }
        if (this.jdbc) {
            if (this.jdbcURL == null) {
                this.jdbcURL = "jdbc:derby:" + this.getInstance().getAbsolutePath() + "/data/derby/db;create=true";
            }
            filters.put("${jdbcBindings}", this.jdbcBindings);
            filters.put("${jdbcMessages}", this.jdbcMessages);
            filters.put("${jdbcLargeMessages}", this.jdbcLargeMessages);
            filters.put("${jdbcPageStore}", this.jdbcPageStore);
            filters.put("${jdbcNodeManager}", this.jdbcNodeManager);
            filters.put("${jdbcURL}", this.jdbcURL);
            filters.put("${jdbcClassName}", this.jdbcClassName);
            filters.put("${jdbcNetworkTimeout}", "" + this.jdbcNetworkTimeout);
            filters.put("${jdbcLockRenewPeriod}", "" + this.jdbcLockRenewPeriod);
            filters.put("${jdbcLockExpiration}", "" + this.jdbcLockExpiration);
            filters.put("${jdbc}", Create.readTextFile(ETC_DATABASE_STORE_TXT, filters));
        } else {
            filters.put("${jdbc}", "");
        }
        if (this.clustered) {
            filters.put("${host}", this.getHostForClustered());
            if (this.name == null) {
                this.name = this.getHostForClustered();
            }
            String connectorSettings = this.getConnectors(filters);
            filters.put("${name}", this.name);
            filters.put("${connector-config.settings}", connectorSettings);
            filters.put("${cluster-security.settings}", Create.readTextFile(ETC_CLUSTER_SECURITY_SETTINGS_TXT, filters));
            if (this.staticNode != null) {
                String staticCluster = Create.readTextFile(ETC_CLUSTER_STATIC_SETTINGS_TXT, filters);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                int countCluster = this.getStaticNodes().length;
                for (int i = 0; i < countCluster; ++i) {
                    printWriter.println("               <connector-ref>node" + i + "</connector-ref>");
                }
                filters.put("${connectors-list}", stringWriter.toString());
                staticCluster = Create.applyFilters(staticCluster, filters);
                filters.put("${cluster.settings}", staticCluster);
            } else {
                filters.put("${cluster.settings}", Create.readTextFile(ETC_CLUSTER_SETTINGS_TXT, filters));
            }
            filters.put("${cluster-user}", this.getClusterUser());
            filters.put("${cluster-password}", this.getClusterPassword());
        } else {
            if (this.name == null) {
                this.name = this.getHost();
            }
            filters.put("${name}", this.name);
            filters.put("${host}", this.getHost());
            filters.put("${connector-config.settings}", "");
            filters.put("${cluster-security.settings}", "");
            filters.put("${cluster.settings}", "");
            filters.put("${cluster-user}", "");
            filters.put("${cluster-password}", "");
        }
        this.applyAddressesAndQueues(filters);
        if (this.home != null) {
            filters.put("${home}", Create.path(this.home));
        }
        new File(this.directory, "bin").mkdirs();
        File etcFolder = this.createDirectory(this.etc, this.directory);
        new File(this.directory, "tmp").mkdirs();
        new File(this.directory, "lib").mkdirs();
        File dataFolder = this.createDirectory(this.data, this.directory);
        File logFolder = this.createDirectory("log", this.directory);
        File oomeDumpFile = new File(logFolder, "oom_dump.hprof");
        String processedJavaOptions = this.getJavaOptions();
        String processedJavaUtilityOptions = this.getJavaUtilityOptions();
        Create.addScriptFilters(filters, this.getHome(), this.getInstance(), etcFolder, dataFolder, oomeDumpFile, this.javaMemory, processedJavaOptions, processedJavaUtilityOptions, this.role);
        boolean allowAnonymous = this.isAllowAnonymous();
        Object retentionTag = this.retentionDays > 0 ? (this.retentionMaxBytes != null ? "<journal-retention-directory period=\"" + this.retentionDays + "\" unit=\"DAYS\" storage-limit=\"" + this.retentionMaxBytes + "\">" + this.data + "/retention</journal-retention-directory>" : "<journal-retention-directory period=\"" + this.retentionDays + "\" unit=\"DAYS\">" + this.data + "/retention</journal-retention-directory>") : "\n      <!-- if you want to retain your journal uncomment this following configuration.\n\n      This will allow your system to keep 7 days of your data, up to 10G. Tweak it accordingly to your use case and capacity.\n\n      it is recommended to use a separate storage unit from the journal for performance considerations.\n\n      <journal-retention-directory period=\"7\" unit=\"DAYS\" storage-limit=\"10G\">data/retention</journal-retention-directory>\n\n      You can also enable retention by using the argument journal-retention on the `artemis create` command -->\n\n";
        filters.put("${journal-retention}", (String)retentionTag);
        filters.put("${java-opts}", processedJavaOptions);
        filters.put("${java-memory}", this.javaMemory);
        if (allowAnonymous) {
            this.write(ETC_LOGIN_CONFIG_WITH_GUEST, new File(etcFolder, ETC_LOGIN_CONFIG), filters, false, this.force);
        } else {
            this.write(ETC_LOGIN_CONFIG_WITHOUT_GUEST, new File(etcFolder, ETC_LOGIN_CONFIG), filters, false, this.force);
        }
        this.writeEtc(ETC_ARTEMIS_ROLES_PROPERTIES, etcFolder, filters, false);
        if (this.IS_WINDOWS) {
            this.write(BIN_ARTEMIS_CMD, filters, false);
            this.write(BIN_ARTEMIS_SERVICE_EXE, this.force);
            this.write(BIN_ARTEMIS_SERVICE_EXE_CONFIG, this.force);
            this.write(BIN_ARTEMIS_SERVICE_XML, filters, false);
            this.writeEtc(ETC_ARTEMIS_PROFILE_CMD, etcFolder, filters, false);
            this.writeEtc(ETC_ARTEMIS_UTILITY_PROFILE_CMD, etcFolder, filters, false);
        }
        if (this.IS_NIX) {
            this.write(BIN_ARTEMIS, filters, true);
            this.makeExec(BIN_ARTEMIS);
            this.write(BIN_ARTEMIS_SERVICE, filters, true);
            this.makeExec(BIN_ARTEMIS_SERVICE);
            this.writeEtc(ETC_ARTEMIS_PROFILE, etcFolder, filters, true);
            this.writeEtc(ETC_ARTEMIS_UTILITY_PROFILE, etcFolder, filters, true);
        }
        this.writeEtc(ETC_LOG4J2_PROPERTIES, etcFolder, null, false);
        this.writeEtc(ETC_LOG4J2_UTILITY_PROPERTIES, etcFolder, null, false);
        if (this.noWeb) {
            filters.put("${bootstrap-web-settings}", "");
        } else {
            filters.put("${bootstrap-web-settings}", Create.readTextFile(ETC_BOOTSTRAP_WEB_SETTINGS_TXT, filters));
        }
        if (this.noAmqpAcceptor) {
            filters.put("${amqp-acceptor}", "");
        } else {
            filters.put("${amqp-acceptor}", Create.readTextFile(ETC_AMQP_ACCEPTOR_TXT, filters));
        }
        if (this.noMqttAcceptor) {
            filters.put("${mqtt-acceptor}", "");
        } else {
            filters.put("${mqtt-acceptor}", Create.readTextFile(ETC_MQTT_ACCEPTOR_TXT, filters));
        }
        if (this.noStompAcceptor) {
            filters.put("${stomp-acceptor}", "");
        } else {
            filters.put("${stomp-acceptor}", Create.readTextFile(ETC_STOMP_ACCEPTOR_TXT, filters));
        }
        if (this.noHornetQAcceptor) {
            filters.put("${hornetq-acceptor}", "");
        } else {
            filters.put("${hornetq-acceptor}", Create.readTextFile(ETC_HORNETQ_ACCEPTOR_TXT, filters));
        }
        if (this.paging == null && this.blocking == null) {
            filters.put("${full-policy}", "PAGE");
        } else if (this.paging != null && this.paging.booleanValue()) {
            filters.put("${full-policy}", "PAGE");
        } else if (this.blocking != null && this.blocking.booleanValue()) {
            filters.put("${full-policy}", "BLOCK");
        } else {
            filters.put("${full-policy}", "PAGE");
        }
        filters.put("${auto-create}", this.isAutoCreate() ? "true" : "false");
        filters.put("${auto-delete}", this.autoDelete ? "true" : "false");
        if (this.jdbc) {
            this.noAutoTune = true;
            context.out.println();
            this.printStar("Copy a jar containing the JDBC Driver '" + this.jdbcClassName + "' into " + this.directory.getAbsolutePath() + "/lib");
            context.out.println();
        }
        this.performAutoTune(filters, this.journalType, dataFolder);
        this.writeEtc(ETC_BROKER_XML, etcFolder, filters, false);
        this.writeEtc(ETC_ARTEMIS_USERS_PROPERTIES, etcFolder, filters, false);
        if (SecurityManagerType.getType(this.securityManager) == SecurityManagerType.BASIC) {
            filters.put("${security-manager-settings}", Create.readTextFile(ETC_BASIC_SECURITY_MANAGER_TXT, filters));
        } else {
            filters.put("${security-manager-settings}", Create.readTextFile(ETC_JAAS_SECURITY_MANAGER_TXT, filters));
        }
        this.writeEtc(ETC_BOOTSTRAP_XML, etcFolder, filters, false);
        this.writeEtc(ETC_MANAGEMENT_XML, etcFolder, filters, false);
        if (this.relaxJolokia) {
            filters.put("${jolokia.options}", "<!-- option relax-jolokia used, so strict-checking will be removed here -->");
        } else {
            filters.put("${jolokia.options}", "<!-- Check for the proper origin on the server side, too -->\n        <strict-checking/>");
        }
        this.writeEtc(ETC_JOLOKIA_ACCESS_XML, etcFolder, filters, false);
        context.out.println("");
        context.out.println("You can now start the broker by executing:  ");
        context.out.println("");
        context.out.println(String.format("   \"%s\" run", Create.path(new File(this.directory, BIN_ARTEMIS))));
        File service = new File(this.directory, BIN_ARTEMIS_SERVICE);
        context.out.println();
        if (this.IS_NIX) {
            context.out.println("Or you can run the broker in the background using:");
            context.out.println("");
            context.out.println(String.format("   \"%s\" start", Create.path(service)));
            context.out.println("");
        }
        if (this.IS_WINDOWS) {
            service = new File(this.directory, BIN_ARTEMIS_SERVICE_EXE);
            context.out.println("Or you can setup the broker as Windows service and run it in the background:");
            context.out.println("");
            context.out.println(String.format("   \"%s\" install", Create.path(service)));
            context.out.println(String.format("   \"%s\" start", Create.path(service)));
            context.out.println("");
            context.out.println("   To stop the windows service:");
            context.out.println(String.format("      \"%s\" stop", Create.path(service)));
            context.out.println("");
            context.out.println("   To uninstall the windows service");
            context.out.println(String.format("      \"%s\" uninstall", Create.path(service)));
        }
        return null;
    }

    protected static void addScriptFilters(Map<String, String> filters, File home, File directory, File etcFolder, File dataFolder, File oomeDumpFile, String javaMemory, String javaOptions, String javaUtilityOptions, String role) throws IOException {
        filters.put("${artemis.home}", Create.path(home));
        filters.put("@artemis.instance@", Create.path(directory));
        filters.put("${artemis.instance.name}", directory.getName());
        filters.put("${java.home}", Create.path(System.getProperty("java.home")));
        filters.put("${artemis.instance.etc.uri}", etcFolder.toURI().toString());
        filters.put("${artemis.instance.etc}", Create.path(etcFolder));
        filters.put("${artemis.instance.oome.dump}", Create.path(oomeDumpFile));
        filters.put("${artemis.instance.data}", Create.path(dataFolder));
        filters.put("${java-memory}", javaMemory);
        filters.put("${java-opts}", javaOptions);
        filters.put("${java-utility-opts}", javaUtilityOptions);
        filters.put("${role}", role);
    }

    private String getConnectors(Map<String, String> filters) throws IOException {
        if (this.staticNode != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printer = new PrintWriter(stringWriter);
            printer.println("      <connectors>");
            printer.println("            <!-- Connector used to be announced through cluster connections and notifications -->");
            printer.println(Create.applyFilters("            <connector name=\"artemis\">tcp://${host}:${default.port}</connector>", filters));
            int counter = 0;
            for (String node : this.getStaticNodes()) {
                printer.println("            <connector name = \"node" + counter++ + "\">" + node + "</connector>");
            }
            printer.println("      </connectors>");
            return stringWriter.toString();
        }
        return Create.readTextFile(ETC_CONNECTOR_SETTINGS_TXT, filters);
    }

    private void printStar(String message) {
        String separator = "*".repeat(Math.min(message.length(), 80));
        this.getActionContext().out.println(separator);
        this.getActionContext().out.println();
        this.getActionContext().out.println(message);
        this.getActionContext().out.println();
        this.getActionContext().out.println(separator);
    }

    private void setupJournalType() {
        int countJournalTypes;
        boolean useMapped;
        if (this.noJournalSync && !this.mapped && (useMapped = this.inputBoolean("--mapped", "Since you disabled syncs, it is recommended to use the Mapped Memory Journal. Do you want to use the Memory Mapped Journal", true))) {
            this.mapped = true;
            this.nio = false;
            this.aio = false;
        }
        if ((countJournalTypes = Create.countBoolean(this.aio, this.nio, this.mapped)) > 1) {
            throw new RuntimeException("You can only select one journal type (--nio | --aio | --mapped).");
        }
        if (countJournalTypes == 0) {
            if (this.supportsLibaio()) {
                this.aio = true;
            } else {
                this.nio = true;
            }
        }
        if (this.aio) {
            this.journalType = JournalType.ASYNCIO;
        } else if (this.nio) {
            this.journalType = JournalType.NIO;
        } else if (this.mapped) {
            this.journalType = JournalType.MAPPED;
        }
    }

    private static int countBoolean(boolean ... b) {
        int count = 0;
        for (boolean itemB : b) {
            if (!itemB) continue;
            ++count;
        }
        return count;
    }

    private void applyAddressesAndQueues(Map<String, String> filters) {
        String routingType;
        String name;
        String[] seg;
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println();
        for (String str : this.getQueueList()) {
            seg = str.split(":");
            name = seg[0].trim();
            routingType = seg.length == 2 ? seg[1].trim() : "anycast";
            try {
                RoutingType.valueOf((String)routingType.toUpperCase());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getActionContext().err.println("Invalid routing type: " + routingType);
            }
            printWriter.println("         <address name=\"" + name + "\">");
            printWriter.println("            <" + routingType + ">");
            printWriter.println("               <queue name=\"" + name + "\" />");
            printWriter.println("            </" + routingType + ">");
            printWriter.println("         </address>");
        }
        for (String str : this.getAddressList()) {
            seg = str.split(":");
            name = seg[0].trim();
            routingType = seg.length == 2 ? seg[1].trim() : "multicast";
            try {
                RoutingType.valueOf((String)routingType.toUpperCase());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getActionContext().err.println("Invalid routing type: " + routingType);
            }
            printWriter.println("         <address name=\"" + name + "\">");
            printWriter.println("            <" + routingType + "/>");
            printWriter.println("         </address>");
        }
        filters.put("${address-queue.settings}", writer.toString());
    }

    private void performAutoTune(Map<String, String> filters, JournalType journalType, File dataFolder) {
        if (this.noAutoTune) {
            filters.put("${journal-buffer.settings}", "");
            filters.put("${page-sync.settings}", "");
        } else {
            try {
                int writes = 250;
                this.getActionContext().out.println("");
                this.getActionContext().out.println("Auto tuning journal ...");
                if (this.mapped && this.noJournalSync) {
                    HashMap<String, String> syncFilter = new HashMap<String, String>();
                    syncFilter.put("${nanoseconds}", "0");
                    syncFilter.put("${writesPerMillisecond}", "0");
                    syncFilter.put("${maxaio}", "1");
                    this.getActionContext().out.println("...Since you disabled sync and are using MAPPED journal, we are diabling buffer times");
                    filters.put("${journal-buffer.settings}", Create.readTextFile(ETC_JOURNAL_BUFFER_SETTINGS, syncFilter));
                    filters.put("${page-sync.settings}", Create.readTextFile(ETC_PAGE_SYNC_SETTINGS, syncFilter));
                } else {
                    long time = SyncCalculation.syncTest(dataFolder, 4096, writes, 5, this.verbose, !this.noJournalSync, false, "journal-test.tmp", ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio(), journalType, this.getActionContext());
                    long nanoseconds = SyncCalculation.toNanos(time, writes, this.verbose, this.getActionContext());
                    double writesPerMillisecond = (double)writes / (double)time;
                    String writesPerMillisecondStr = new DecimalFormat("###.##").format(writesPerMillisecond);
                    HashMap<String, String> syncFilter = new HashMap<String, String>();
                    syncFilter.put("${nanoseconds}", Long.toString(nanoseconds));
                    syncFilter.put("${writesPerMillisecond}", writesPerMillisecondStr);
                    syncFilter.put("${maxaio}", (String)(journalType == JournalType.ASYNCIO ? "" + this.journalMaxIo : "1"));
                    this.getActionContext().out.println("done! Your system can make " + writesPerMillisecondStr + " writes per millisecond, your journal-buffer-timeout will be " + nanoseconds);
                    filters.put("${journal-buffer.settings}", Create.readTextFile(ETC_JOURNAL_BUFFER_SETTINGS, syncFilter));
                    if (this.noJournalSync) {
                        syncFilter.put("${nanoseconds}", "0");
                    } else if (journalType != JournalType.NIO) {
                        long nioTime = SyncCalculation.syncTest(dataFolder, 4096, writes, 5, this.verbose, !this.noJournalSync, false, "journal-test.tmp", ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio(), JournalType.NIO, this.getActionContext());
                        long nioNanoseconds = SyncCalculation.toNanos(nioTime, writes, this.verbose, this.getActionContext());
                        syncFilter.put("${nanoseconds}", Long.toString(nioNanoseconds));
                    }
                    filters.put("${page-sync.settings}", Create.readTextFile(ETC_PAGE_SYNC_SETTINGS, syncFilter));
                }
            }
            catch (Exception e) {
                filters.put("${journal-buffer.settings}", "");
                filters.put("${page-sync.settings}", "");
                e.printStackTrace();
                this.getActionContext().err.println("Couldn't perform sync calculation, using default values");
            }
        }
    }

    public boolean supportsLibaio() {
        if (this.IS_WINDOWS) {
            return false;
        }
        if (LibaioContext.isLoaded()) {
            try (LibaioContext context = new LibaioContext(1, true, true);){
                File tmpFile = new File(this.directory, "validateAIO.bin");
                boolean supportsLibaio = true;
                try {
                    LibaioFile file = context.openFile(tmpFile, true);
                    file.close();
                }
                catch (Exception e) {
                    supportsLibaio = false;
                }
                tmpFile.delete();
                if (!supportsLibaio) {
                    this.getActionContext().err.println("The filesystem used on " + String.valueOf(this.directory) + " doesn't support libAIO and O_DIRECT files, switching journal-type to NIO");
                }
                boolean bl = supportsLibaio;
                return bl;
            }
        }
        return false;
    }

    private void makeExec(String path) throws IOException {
        FileUtil.makeExec((File)new File(this.directory, path));
    }

    private String[] getQueueList() {
        if (this.queues == null) {
            return new String[0];
        }
        return this.queues.split(",");
    }

    private String[] getAddressList() {
        if (this.addresses == null) {
            return new String[0];
        }
        return this.addresses.split(",");
    }

    private static String path(String value) throws IOException {
        return Create.path(new File(value));
    }

    private static String path(File value) throws IOException {
        return value.getCanonicalPath();
    }

    private void write(String source, Map<String, String> filters, boolean unixTarget) throws Exception {
        this.write(source, new File(this.directory, source), filters, unixTarget, this.force);
    }

    private void writeEtc(String source, File etcFolder, Map<String, String> filters, boolean unixTarget) throws Exception {
        this.write("etc/" + source, new File(etcFolder, source), filters, unixTarget, this.force);
    }

    private static enum SecurityManagerType {
        JAAS,
        BASIC;


        public static SecurityManagerType getType(String type) {
            return switch (type = type.toLowerCase()) {
                case "jaas" -> JAAS;
                case "basic" -> BASIC;
                default -> null;
            };
        }
    }
}

