% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbc.R, R/options.R
\name{adbc_database_init}
\alias{adbc_database_init}
\alias{adbc_database_init_default}
\alias{adbc_database_release}
\alias{adbc_database_set_options}
\alias{adbc_database_get_option}
\alias{adbc_database_get_option_bytes}
\alias{adbc_database_get_option_int}
\alias{adbc_database_get_option_double}
\title{Databases}
\usage{
adbc_database_init(driver, ...)

adbc_database_init_default(driver, options = NULL, subclass = character())

adbc_database_release(database)

adbc_database_set_options(database, options)

adbc_database_get_option(database, option)

adbc_database_get_option_bytes(database, option)

adbc_database_get_option_int(database, option)

adbc_database_get_option_double(database, option)
}
\arguments{
\item{driver}{An \code{\link[=adbc_driver]{adbc_driver()}}.}

\item{...}{Driver-specific options. For the default method, these are
named values that are converted to strings.}

\item{options}{A named \code{character()} or \code{list()} whose values are converted
to strings.}

\item{subclass}{An extended class for an object so that drivers can specify
finer-grained control over behaviour at the R level.}

\item{database}{An \link[=adbc_database_init]{adbc_database}.}

\item{option}{A specific option name}
}
\value{
An object of class adbc_database
}
\description{
Databases
}
\examples{
adbc_database_init(adbc_driver_void())

}
