<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Avro test files for `arrow-avro`

This directory contains small Avro Object Container Files (OCF) used by
`arrow-avro` tests to validate the `Reader` implementation. These files are generated from 
a set of python scripts and will gradually be removed as they are merged into `arrow-testing`.

## Decimal Files

This directory contains OCF files used to exercise decoding of Avro’s `decimal` logical type 
across both `bytes` and `fixed` encodings, and to cover Arrow decimal widths ranging
from `Decimal32` up through `Decimal256`. The files were generated from a
script (see **How these files were created** below).

> **Avro decimal recap.** Avro’s `decimal` logical type annotates either a
> `bytes` or `fixed` primitive and stores the **two’s‑complement big‑endian
> representation of the unscaled integer** (value × 10^scale). Implementations
> should reject invalid combinations such as `scale > precision`.

> **Arrow decimal recap.** Arrow defines `Decimal32`, `Decimal64`, `Decimal128`,
> and `Decimal256` types with maximum precisions of 9, 18, 38, and 76 digits,
> respectively. Tests here validate that the Avro reader selects compatible
> Arrow decimal widths given the Avro decimal’s precision and storage.

---

All files are one‑column Avro OCFs with a field named `value`. Each contains 24
rows with the sequence `1 … 24` rendered at the file’s declared `scale`
(i.e., at scale 10: `1.0000000000`, `2.0000000000`).

| File | Avro storage | Decimal (precision, scale) | Intended Arrow width |
|---|---|---|---|
| `int256_decimal.avro` | `bytes` + `logicalType: decimal` | (76, 10) | `Decimal256` |
| `fixed256_decimal.avro` | `fixed[32]` + `logicalType: decimal` | (76, 10) | `Decimal256` |
| `fixed_length_decimal_legacy_32.avro` | `fixed[4]` + `logicalType: decimal` | (9, 2) | `Decimal32` (legacy fixed‑width path) |
| `int128_decimal.avro` | `bytes` + `logicalType: decimal` | (38, 2) | `Decimal128` |

### Schemas (for reference)

#### int256_decimal.avro

```json
{
  "type": "record",
  "name": "OneColDecimal256Bytes",
  "fields": [{
    "name": "value",
    "type": { "type": "bytes", "logicalType": "decimal", "precision": 76, "scale": 10 }
  }]
}
```

#### fixed256_decimal.avro

```json
{
  "type": "record",
  "name": "OneColDecimal256Fixed",
  "fields": [{
    "name": "value",
    "type": {
      "type": "fixed", "name": "Decimal256Fixed", "size": 32,
      "logicalType": "decimal", "precision": 76, "scale": 10
    }
  }]
}
```

#### fixed_length_decimal_legacy_32.avro

```json
{
  "type": "record",
  "name": "OneColDecimal32FixedLegacy",
  "fields": [{
    "name": "value",
    "type": {
      "type": "fixed", "name": "Decimal32FixedLegacy", "size": 4,
      "logicalType": "decimal", "precision": 9, "scale": 2
    }
  }]
}
```

#### int128_decimal.avro

```json
{
  "type": "record",
  "name": "OneColDecimal128Bytes",
  "fields": [{
    "name": "value",
    "type": { "type": "bytes", "logicalType": "decimal", "precision": 38, "scale": 2 }
  }]
}
```

### How these files were created

All four files were generated by the Python script
`create_avro_decimal_files.py` authored for this purpose. The script uses
`fastavro` to write OCFs and encodes decimal values as required by the Avro
spec (two’s‑complement big‑endian of the unscaled integer).

#### Re‑generation

From the repository root (defaults write into arrow-avro/test/data):

```bash
# 1) Ensure Python 3 is available, then install fastavro
python -m pip install --upgrade fastavro

# 2) Fetch the script
curl -L -o create_avro_decimal_files.py \
https://gist.githubusercontent.com/jecsand838/3890349bdb33082a3e8fdcae3257eef7/raw/create_avro_decimal_files.py

# 3) Generate the files (prints a verification dump by default)
python create_avro_decimal_files.py -o arrow-avro/test/data
```

Options:
* --num-rows (default 24) — number of rows to emit per file
* --scale (default 10) — the decimal scale used for the 256 files
* --no-verify — skip reading the files back for printed verification

## Other Files

This directory contains other small OCF files used by `arrow-avro` tests. Details on these will be added in 
follow-up PRs.