/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="netstats", description="Print network information on provided host (connecting node by default)")
public class NetStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.printf("Mode: %s%n", probe.getOperationMode());
        Set<StreamState> statuses = probe.getStreamStatus();
        if (statuses.isEmpty()) {
            out.println("Not sending any streams.");
        }
        for (StreamState status : statuses) {
            out.printf("%s %s%n", status.streamOperation.getDescription(), status.planId.toString());
            for (SessionInfo info : status.sessions) {
                out.printf("    %s", info.peer.toString(this.printPort));
                if (!info.peer.equals(info.connecting)) {
                    out.printf(" (using %s)", info.connecting.toString(this.printPort));
                }
                out.printf("%n", new Object[0]);
                if (!info.receivingSummaries.isEmpty()) {
                    this.printReceivingSummaries(out, info, this.humanReadable);
                }
                if (info.sendingSummaries.isEmpty()) continue;
                this.printSendingSummaries(out, info, this.humanReadable);
            }
        }
        if (!probe.isStarting()) {
            out.printf("Read Repair Statistics:%nAttempted: %d%nMismatch (Blocking): %d%nMismatch (Background): %d%n", probe.getReadRepairAttempted(), probe.getReadRepairRepairedBlocking(), probe.getReadRepairRepairedBackground());
            MessagingServiceMBean ms = probe.getMessagingServiceProxy();
            out.printf("%-25s", "Pool Name");
            out.printf("%10s", "Active");
            out.printf("%10s", "Pending");
            out.printf("%15s", "Completed");
            out.printf("%10s%n", "Dropped");
            int pending = 0;
            Iterator<Number> iterator = ms.getLargeMessagePendingTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                pending += n;
            }
            long completed = 0L;
            iterator = ms.getLargeMessageCompletedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            long dropped = 0L;
            iterator = ms.getLargeMessageDroppedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Large messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getSmallMessagePendingTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getSmallMessageCompletedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getSmallMessageDroppedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Small messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getGossipMessagePendingTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getGossipMessageCompletedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getGossipMessageDroppedTasksWithPort().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Gossip messages", "n/a", pending, completed, dropped);
        }
    }

    @VisibleForTesting
    public void printReceivingSummaries(PrintStream out, SessionInfo info, boolean printHumanReadable) {
        long totalFilesToReceive = info.getTotalFilesToReceive();
        long totalBytesToReceive = info.getTotalSizeToReceive();
        long totalFilesReceived = info.getTotalFilesReceived();
        long totalSizeReceived = info.getTotalSizeReceived();
        double percentageFilesReceived = (double)totalFilesReceived / (double)totalFilesToReceive * 100.0;
        double percentageSizesReceived = (double)totalSizeReceived / (double)totalBytesToReceive * 100.0;
        out.printf("        Receiving %d files, %s total. Already received %d files (%.2f%%), %s total (%.2f%%)%n", totalFilesToReceive, printHumanReadable ? FileUtils.stringifyFileSize(totalBytesToReceive) : Long.toString(totalBytesToReceive) + " bytes", totalFilesReceived, percentageFilesReceived, printHumanReadable ? FileUtils.stringifyFileSize(totalSizeReceived) : Long.toString(totalSizeReceived) + " bytes", percentageSizesReceived);
        for (ProgressInfo progress : info.getReceivingFiles()) {
            out.printf("            %s%n", progress.toString(this.printPort));
        }
    }

    @VisibleForTesting
    public void printSendingSummaries(PrintStream out, SessionInfo info, boolean printHumanReadable) {
        long totalFilesToSend = info.getTotalFilesToSend();
        long totalSizeToSend = info.getTotalSizeToSend();
        long totalFilesSent = info.getTotalFilesSent();
        long totalSizeSent = info.getTotalSizeSent();
        double percentageFilesSent = (double)totalFilesSent / (double)totalFilesToSend * 100.0;
        double percentageSizeSent = (double)totalSizeSent / (double)totalSizeToSend * 100.0;
        out.printf("        Sending %d files, %s total. Already sent %d files (%.2f%%), %s total (%.2f%%)%n", totalFilesToSend, printHumanReadable ? FileUtils.stringifyFileSize(totalSizeToSend) : Long.toString(totalSizeToSend) + " bytes", totalFilesSent, percentageFilesSent, printHumanReadable ? FileUtils.stringifyFileSize(totalSizeSent) : Long.toString(totalSizeSent) + " bytes", percentageSizeSent);
        for (ProgressInfo progress : info.getSendingFiles()) {
            out.printf("            %s%n", progress.toString(this.printPort));
        }
    }
}

