/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import org.apache.cassandra.concurrent.ExecutorBuilder;
import org.apache.cassandra.concurrent.ExecutorBuilderFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.InfiniteLoopExecutor;
import org.apache.cassandra.concurrent.Interruptible;
import org.apache.cassandra.concurrent.LocalAwareExecutorPlus;
import org.apache.cassandra.concurrent.LocalAwareSequentialExecutorPlus;
import org.apache.cassandra.concurrent.LocalAwareSingleThreadExecutorPlus;
import org.apache.cassandra.concurrent.LocalAwareThreadPoolExecutorPlus;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ScheduledExecutorPlus;
import org.apache.cassandra.concurrent.ScheduledThreadPoolExecutorPlus;
import org.apache.cassandra.concurrent.SequentialExecutorPlus;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.concurrent.SingleThreadExecutorPlus;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBuilder;
import org.apache.cassandra.concurrent.ThreadPoolExecutorPlus;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface ExecutorFactory
extends ExecutorBuilderFactory.Jmxable<ExecutorPlus, SequentialExecutorPlus> {
    public LocalAwareSubFactory localAware();

    default public ScheduledExecutorPlus scheduled(String name) {
        return this.scheduled(true, name, 5);
    }

    default public ScheduledExecutorPlus scheduled(String name, SimulatorSemantics simulatorSemantics) {
        return this.scheduled(true, name, 5, simulatorSemantics);
    }

    default public ScheduledExecutorPlus scheduled(boolean executeOnShutdown, String name) {
        return this.scheduled(executeOnShutdown, name, 5);
    }

    default public ScheduledExecutorPlus scheduled(boolean executeOnShutdown, String name, int priority) {
        return this.scheduled(executeOnShutdown, name, priority, SimulatorSemantics.NORMAL);
    }

    public ScheduledExecutorPlus scheduled(boolean var1, String var2, int var3, SimulatorSemantics var4);

    public Thread startThread(String var1, Runnable var2, InfiniteLoopExecutor.Daemon var3);

    default public Thread startThread(String name, Runnable runnable) {
        return this.startThread(name, runnable, InfiniteLoopExecutor.Daemon.DAEMON);
    }

    public Interruptible infiniteLoop(String var1, Interruptible.Task var2, InfiniteLoopExecutor.SimulatorSafe var3, InfiniteLoopExecutor.Daemon var4, InfiniteLoopExecutor.Interrupts var5);

    default public Interruptible infiniteLoop(String name, Interruptible.SimpleTask task, InfiniteLoopExecutor.SimulatorSafe simulatorSafe) {
        return this.infiniteLoop(name, Interruptible.Task.from(task), simulatorSafe, InfiniteLoopExecutor.Daemon.DAEMON, InfiniteLoopExecutor.Interrupts.UNSYNCHRONIZED);
    }

    public ThreadGroup newThreadGroup(String var1);

    public static final class Default
    extends NamedThreadFactory.MetaFactory
    implements ExecutorFactory {
        public Default(ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            super(contextClassLoader, threadGroup, uncaughtExceptionHandler);
        }

        @Override
        public LocalAwareSubFactory localAware() {
            return new LocalAwareSubFactory(){

                @Override
                public ExecutorBuilder<? extends LocalAwareSequentialExecutorPlus> configureSequential(String name) {
                    return ThreadPoolExecutorBuilder.sequential(LocalAwareSingleThreadExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name);
                }

                @Override
                public ExecutorBuilder<LocalAwareThreadPoolExecutorPlus> configurePooled(String name, int threads) {
                    return ThreadPoolExecutorBuilder.pooled(LocalAwareThreadPoolExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, threads);
                }

                @Override
                public LocalAwareSubFactoryWithJMX withJmx(final String jmxPath) {
                    return new LocalAwareSubFactoryWithJMX(){

                        @Override
                        public ExecutorBuilder<LocalAwareSingleThreadExecutorPlus> configureSequential(String name) {
                            return ThreadPoolExecutorBuilder.sequentialJmx(LocalAwareSingleThreadExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, jmxPath);
                        }

                        @Override
                        public ExecutorBuilder<LocalAwareThreadPoolExecutorPlus> configurePooled(String name, int threads) {
                            return ThreadPoolExecutorBuilder.pooledJmx(LocalAwareThreadPoolExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, threads, jmxPath);
                        }

                        @Override
                        public LocalAwareExecutorPlus shared(String name, int threads, ExecutorPlus.MaximumPoolSizeListener onSetMaxSize) {
                            return SharedExecutorPool.SHARED.newExecutor(threads, onSetMaxSize, jmxPath, name);
                        }
                    };
                }
            };
        }

        @Override
        public ExecutorBuilderFactory<ExecutorPlus, SequentialExecutorPlus> withJmx(final String jmxPath) {
            return new ExecutorBuilderFactory<ExecutorPlus, SequentialExecutorPlus>(){

                @Override
                public ExecutorBuilder<? extends SequentialExecutorPlus> configureSequential(String name) {
                    return ThreadPoolExecutorBuilder.sequentialJmx(SingleThreadExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, jmxPath);
                }

                @Override
                public ExecutorBuilder<? extends ExecutorPlus> configurePooled(String name, int threads) {
                    return ThreadPoolExecutorBuilder.pooledJmx(ThreadPoolExecutorPlus::new, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, threads, jmxPath);
                }
            };
        }

        @Override
        public ExecutorBuilder<SingleThreadExecutorPlus> configureSequential(String name) {
            return ThreadPoolExecutorBuilder.sequential(SingleThreadExecutorPlus::new, this.contextClassLoader, this.threadGroup, this.uncaughtExceptionHandler, name);
        }

        @Override
        public ExecutorBuilder<ThreadPoolExecutorPlus> configurePooled(String name, int threads) {
            return ThreadPoolExecutorBuilder.pooled(ThreadPoolExecutorPlus::new, this.contextClassLoader, this.threadGroup, this.uncaughtExceptionHandler, name, threads);
        }

        @Override
        public ScheduledExecutorPlus scheduled(boolean executeOnShutdown, String name, int priority, SimulatorSemantics simulatorSemantics) {
            ScheduledThreadPoolExecutorPlus executor = new ScheduledThreadPoolExecutorPlus(this.newThreadFactory(name, priority));
            if (!executeOnShutdown) {
                executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            }
            return executor;
        }

        @Override
        public Thread startThread(String name, Runnable runnable, InfiniteLoopExecutor.Daemon daemon) {
            Thread thread = NamedThreadFactory.setupThread(NamedThreadFactory.createThread(this.threadGroup, runnable, name, daemon == InfiniteLoopExecutor.Daemon.DAEMON), 5, this.contextClassLoader, this.uncaughtExceptionHandler);
            thread.start();
            return thread;
        }

        @Override
        public Interruptible infiniteLoop(String name, Interruptible.Task task, InfiniteLoopExecutor.SimulatorSafe simulatorSafe, InfiniteLoopExecutor.Daemon daemon, InfiniteLoopExecutor.Interrupts interrupts) {
            return new InfiniteLoopExecutor(this, name, task, daemon, interrupts);
        }

        @Override
        public ThreadGroup newThreadGroup(String name) {
            return this.threadGroup == null ? null : new ThreadGroup(this.threadGroup, name);
        }
    }

    public static final class Global {
        private static ExecutorFactory FACTORY = new Default(Global.class.getClassLoader(), null, JVMStabilityInspector::uncaughtException);
        private static boolean modified;

        public static ExecutorFactory executorFactory() {
            return FACTORY;
        }

        public static synchronized void unsafeSet(ExecutorFactory executorFactory) {
            FACTORY = executorFactory;
            modified = true;
        }

        public static synchronized boolean tryUnsafeSet(ExecutorFactory executorFactory) {
            if (modified) {
                return false;
            }
            Global.unsafeSet(executorFactory);
            return true;
        }
    }

    public static enum SimulatorSemantics {
        NORMAL,
        DISCARD;

    }

    public static interface LocalAwareSubFactory
    extends ExecutorBuilderFactory<LocalAwareExecutorPlus, LocalAwareSequentialExecutorPlus> {
        public LocalAwareSubFactoryWithJMX withJmx(String var1);

        default public LocalAwareSubFactoryWithJMX withJmxInternal() {
            return this.withJmx("internal");
        }
    }

    public static interface LocalAwareSubFactoryWithJMX
    extends ExecutorBuilderFactory<LocalAwareExecutorPlus, LocalAwareSequentialExecutorPlus> {
        public LocalAwareExecutorPlus shared(String var1, int var2, ExecutorPlus.MaximumPoolSizeListener var3);
    }
}

