/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFcts {
    public static Logger logger = LoggerFactory.getLogger(TimeFcts.class);
    public static final Function minTimeuuidFct = new NativeScalarFunction("mintimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return TimeUUID.minAtUnixMillis(((Date)TimestampType.instance.compose(bb)).getTime()).toBytes();
        }
    };
    public static final Function maxTimeuuidFct = new NativeScalarFunction("maxtimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return TimeUUID.maxAtUnixMillis(((Date)TimestampType.instance.compose(bb)).getTime()).toBytes();
        }
    };
    public static final NativeScalarFunction dateOfFct = new NativeScalarFunction("dateof", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'dateof' is deprecated. Use the function 'toTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            long timeInMillis = TimeUUID.deserialize(bb).unix(TimeUnit.MILLISECONDS);
            return ByteBufferUtil.bytes(timeInMillis);
        }
    };
    public static final NativeScalarFunction unixTimestampOfFct = new NativeScalarFunction("unixtimestampof", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'unixtimestampof' is deprecated. Use the function 'toUnixTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            return ByteBufferUtil.bytes(TimeUUID.deserialize(bb).unix(TimeUnit.MILLISECONDS));
        }
    };
    public static final NativeScalarFunction floorTime = new NativeScalarFunction("floor", (AbstractType)TimeType.instance, new AbstractType[]{TimeType.instance, DurationType.instance}){

        @Override
        protected boolean isPartialApplicationMonotonic(List<ByteBuffer> partialParameters) {
            return partialParameters.get(0) == UNRESOLVED && partialParameters.get(1) != UNRESOLVED;
        }

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer timeBuffer = parameters.get(0);
            ByteBuffer durationBuffer = parameters.get(1);
            if (timeBuffer == null || durationBuffer == null) {
                return null;
            }
            Long time = (Long)TimeType.instance.compose(timeBuffer);
            Duration duration = (Duration)DurationType.instance.compose(durationBuffer);
            if (time == null || duration == null) {
                return null;
            }
            long floor = Duration.floorTime(time, duration);
            return TimeType.instance.decompose(floor);
        }
    };

    public static Collection<Function> all() {
        return ImmutableList.of((Object)TimeFcts.now("now", TimeUUIDType.instance), (Object)TimeFcts.now("currenttimeuuid", TimeUUIDType.instance), (Object)TimeFcts.now("currenttimestamp", TimestampType.instance), (Object)TimeFcts.now("currentdate", SimpleDateType.instance), (Object)TimeFcts.now("currenttime", TimeType.instance), (Object)minTimeuuidFct, (Object)maxTimeuuidFct, (Object)dateOfFct, (Object)unixTimestampOfFct, (Object)TimeFcts.toDate(TimeUUIDType.instance), (Object)TimeFcts.toTimestamp(TimeUUIDType.instance), (Object)TimeFcts.toUnixTimestamp(TimeUUIDType.instance), (Object[])new Function[]{TimeFcts.toUnixTimestamp(TimestampType.instance), TimeFcts.toDate(TimestampType.instance), TimeFcts.toUnixTimestamp(SimpleDateType.instance), TimeFcts.toTimestamp(SimpleDateType.instance), FloorTimestampFunction.newInstance(), FloorTimestampFunction.newInstanceWithStartTimeArgument(), FloorTimeUuidFunction.newInstance(), FloorTimeUuidFunction.newInstanceWithStartTimeArgument(), FloorDateFunction.newInstance(), FloorDateFunction.newInstanceWithStartTimeArgument(), floorTime});
    }

    public static final Function now(String name, final TemporalType<?> type) {
        return new NativeScalarFunction(name, type, new AbstractType[0]){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                return type.now();
            }

            @Override
            public boolean isPure() {
                return false;
            }
        };
    }

    public static final NativeScalarFunction toDate(final TemporalType<?> type) {
        return new NativeScalarFunction("todate", (AbstractType)SimpleDateType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                long millis = type.toTimeInMillis(bb);
                return SimpleDateType.instance.fromTimeInMillis(millis);
            }

            @Override
            public boolean isMonotonic() {
                return true;
            }
        };
    }

    public static final NativeScalarFunction toTimestamp(final TemporalType<?> type) {
        return new NativeScalarFunction("totimestamp", (AbstractType)TimestampType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                long millis = type.toTimeInMillis(bb);
                return TimestampType.instance.fromTimeInMillis(millis);
            }

            @Override
            public boolean isMonotonic() {
                return true;
            }
        };
    }

    public static final NativeScalarFunction toUnixTimestamp(final TemporalType<?> type) {
        return new NativeScalarFunction("tounixtimestamp", (AbstractType)LongType.instance, new AbstractType[]{type}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                ByteBuffer bb = parameters.get(0);
                if (bb == null || !bb.hasRemaining()) {
                    return null;
                }
                return ByteBufferUtil.bytes(type.toTimeInMillis(bb));
            }

            @Override
            public boolean isMonotonic() {
                return true;
            }
        };
    }

    public static final class FloorDateFunction
    extends FloorFunction {
        public static FloorDateFunction newInstance() {
            return new FloorDateFunction(SimpleDateType.instance, SimpleDateType.instance, DurationType.instance);
        }

        public static FloorDateFunction newInstanceWithStartTimeArgument() {
            return new FloorDateFunction(SimpleDateType.instance, SimpleDateType.instance, DurationType.instance, SimpleDateType.instance);
        }

        private FloorDateFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return SimpleDateType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        protected Long toStartingTimeInMillis(ByteBuffer bytes) {
            return SimpleDateType.instance.toTimeInMillis(bytes);
        }

        @Override
        protected Long toTimeInMillis(ByteBuffer bytes) {
            return SimpleDateType.instance.toTimeInMillis(bytes);
        }

        @Override
        protected void validateDuration(Duration duration) {
            if (duration.getNanoseconds() != 0L) {
                throw RequestValidations.invalidRequest("The floor on %s values cannot be computed for the %s duration as precision is below 1 day", SimpleDateType.instance.asCQL3Type(), duration);
            }
        }
    }

    public static final class FloorTimeUuidFunction
    extends FloorFunction {
        public static FloorTimeUuidFunction newInstance() {
            return new FloorTimeUuidFunction(TimestampType.instance, TimeUUIDType.instance, DurationType.instance);
        }

        public static FloorTimeUuidFunction newInstanceWithStartTimeArgument() {
            return new FloorTimeUuidFunction(TimestampType.instance, TimeUUIDType.instance, DurationType.instance, TimestampType.instance);
        }

        private FloorTimeUuidFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        protected Long toStartingTimeInMillis(ByteBuffer bytes) {
            return TimestampType.instance.toTimeInMillis(bytes);
        }

        @Override
        protected Long toTimeInMillis(ByteBuffer bytes) {
            return UUIDGen.getAdjustedTimestamp(UUIDGen.getUUID(bytes));
        }
    }

    public static final class FloorTimestampFunction
    extends FloorFunction {
        public static FloorTimestampFunction newInstance() {
            return new FloorTimestampFunction(TimestampType.instance, TimestampType.instance, DurationType.instance);
        }

        public static FloorTimestampFunction newInstanceWithStartTimeArgument() {
            return new FloorTimestampFunction(TimestampType.instance, TimestampType.instance, DurationType.instance, TimestampType.instance);
        }

        private FloorTimestampFunction(AbstractType<?> returnType, AbstractType<?> ... argTypes) {
            super(returnType, argTypes);
        }

        @Override
        protected ByteBuffer fromTimeInMillis(long timeInMillis) {
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }

        @Override
        protected Long toStartingTimeInMillis(ByteBuffer bytes) {
            return TimestampType.instance.toTimeInMillis(bytes);
        }

        @Override
        protected Long toTimeInMillis(ByteBuffer bytes) {
            return TimestampType.instance.toTimeInMillis(bytes);
        }
    }

    private static abstract class FloorFunction
    extends NativeScalarFunction {
        private static final Long ZERO = 0L;

        protected FloorFunction(AbstractType<?> returnType, AbstractType<?> ... argsType) {
            super("floor", returnType, argsType);
            assert (argsType.length == 2 || argsType.length == 3);
        }

        @Override
        protected boolean isPartialApplicationMonotonic(List<ByteBuffer> partialParameters) {
            return partialParameters.get(0) == UNRESOLVED && partialParameters.get(1) != UNRESOLVED && (partialParameters.size() == 2 || partialParameters.get(2) != UNRESOLVED);
        }

        @Override
        public final ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer timeBuffer = parameters.get(0);
            ByteBuffer durationBuffer = parameters.get(1);
            Long startingTime = this.getStartingTime(parameters);
            if (timeBuffer == null || durationBuffer == null || startingTime == null) {
                return null;
            }
            Long time = this.toTimeInMillis(timeBuffer);
            Duration duration = (Duration)DurationType.instance.compose(durationBuffer);
            if (time == null || duration == null) {
                return null;
            }
            this.validateDuration(duration);
            long floor = Duration.floorTimestamp(time, duration, startingTime);
            return this.fromTimeInMillis(floor);
        }

        private Long getStartingTime(List<ByteBuffer> parameters) {
            if (parameters.size() == 3) {
                ByteBuffer startingTimeBuffer = parameters.get(2);
                if (startingTimeBuffer == null) {
                    return null;
                }
                return this.toStartingTimeInMillis(startingTimeBuffer);
            }
            return ZERO;
        }

        protected void validateDuration(Duration duration) {
            if (!duration.hasMillisecondPrecision()) {
                throw RequestValidations.invalidRequest("The floor cannot be computed for the %s duration as precision is below 1 millisecond", duration);
            }
        }

        protected abstract ByteBuffer fromTimeInMillis(long var1);

        protected abstract Long toTimeInMillis(ByteBuffer var1);

        protected abstract Long toStartingTimeInMillis(ByteBuffer var1);
    }
}

