/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

final class AggregateFunctionSelector
extends AbstractFunctionSelector<AggregateFunction> {
    protected static final Selector.SelectorDeserializer deserializer = new AbstractFunctionSelector.AbstractFunctionSelectorDeserializer(){

        @Override
        protected Selector newFunctionSelector(Function function, List<Selector> argSelectors) {
            return new AggregateFunctionSelector(function, argSelectors);
        }
    };
    private final AggregateFunction.Aggregate aggregate;

    public boolean isAggregate() {
        return true;
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        int m = this.argSelectors.size();
        for (int i = 0; i < m; ++i) {
            Selector s = (Selector)this.argSelectors.get(i);
            s.addInput(protocolVersion, input);
            this.setArg(i, s.getOutput(protocolVersion));
            s.reset();
        }
        this.aggregate.addInput(protocolVersion, this.args());
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        return this.aggregate.compute(protocolVersion);
    }

    @Override
    public void reset() {
        this.aggregate.reset();
    }

    AggregateFunctionSelector(Function fun, List<Selector> argSelectors) throws InvalidRequestException {
        super(Selector.Kind.AGGREGATE_FUNCTION_SELECTOR, (AggregateFunction)fun, argSelectors);
        this.aggregate = ((AggregateFunction)this.fun).newAggregate();
    }
}

