/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.concurrent.TimeoutException;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.QualifiedStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.TruncateException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class TruncateStatement
extends QualifiedStatement
implements CQLStatement {
    public TruncateStatement(QualifiedName name) {
        super(name);
    }

    @Override
    public TruncateStatement prepare(ClientState state) {
        return this;
    }

    @Override
    public void authorize(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.ensureTablePermission(this.keyspace(), this.name(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        Schema.instance.validateTable(this.keyspace(), this.name());
        Guardrails.dropTruncateTableEnabled.ensureEnabled(state);
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options, Dispatcher.RequestTime requestTime) throws InvalidRequestException, TruncateException {
        try {
            TableMetadata metaData = Schema.instance.getTableMetadata(this.keyspace(), this.name());
            if (metaData.isView()) {
                throw new InvalidRequestException("Cannot TRUNCATE materialized view directly; must truncate base table instead");
            }
            if (metaData.isVirtual()) {
                this.executeForVirtualTable(metaData.id);
            } else {
                StorageProxy.truncateBlocking(this.keyspace(), this.name());
            }
        }
        catch (TimeoutException | UnavailableException e) {
            throw new TruncateException(e);
        }
        return null;
    }

    @Override
    public ResultMessage executeLocally(QueryState state, QueryOptions options) {
        try {
            TableMetadata metaData = Schema.instance.getTableMetadata(this.keyspace(), this.name());
            if (metaData.isView()) {
                throw new InvalidRequestException("Cannot TRUNCATE materialized view directly; must truncate base table instead");
            }
            if (metaData.isVirtual()) {
                this.executeForVirtualTable(metaData.id);
            } else {
                ColumnFamilyStore cfs = Keyspace.open(this.keyspace()).getColumnFamilyStore(this.name());
                cfs.truncateBlocking();
            }
        }
        catch (Exception e) {
            throw new TruncateException(e);
        }
        return null;
    }

    private void executeForVirtualTable(TableId id) {
        VirtualKeyspaceRegistry.instance.getTableNullable(id).truncate();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.TRUNCATE, this.keyspace(), this.name());
    }
}

