/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;

public interface IndexRegistry {
    public static final IndexRegistry EMPTY = new IndexRegistry(){

        @Override
        public void unregisterIndex(Index index) {
        }

        @Override
        public void registerIndex(Index index) {
        }

        @Override
        public Collection<Index> listIndexes() {
            return Collections.emptyList();
        }

        @Override
        public Index getIndex(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public Optional<Index> getBestIndexFor(RowFilter.Expression expression) {
            return Optional.empty();
        }

        @Override
        public void validate(PartitionUpdate update) {
        }
    };
    public static final IndexRegistry NON_DAEMON = new IndexRegistry(){
        Index index = new Index(){

            @Override
            public Callable<?> getInitializationTask() {
                return null;
            }

            @Override
            public IndexMetadata getIndexMetadata() {
                return null;
            }

            @Override
            public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
                return null;
            }

            @Override
            public void register(IndexRegistry registry) {
            }

            @Override
            public Optional<ColumnFamilyStore> getBackingTable() {
                return Optional.empty();
            }

            @Override
            public Callable<?> getBlockingFlushTask() {
                return null;
            }

            @Override
            public Callable<?> getInvalidateTask() {
                return null;
            }

            @Override
            public Callable<?> getTruncateTask(long truncatedAt) {
                return null;
            }

            @Override
            public boolean shouldBuildBlocking() {
                return false;
            }

            @Override
            public boolean dependsOn(ColumnMetadata column) {
                return false;
            }

            @Override
            public boolean supportsExpression(ColumnMetadata column, Operator operator) {
                return true;
            }

            @Override
            public AbstractType<?> customExpressionValueType() {
                return BytesType.instance;
            }

            @Override
            public RowFilter getPostIndexQueryFilter(RowFilter filter) {
                return null;
            }

            @Override
            public long getEstimatedResultRows() {
                return 0L;
            }

            @Override
            public void validate(PartitionUpdate update) throws InvalidRequestException {
            }

            @Override
            public Index.Indexer indexerFor(DecoratedKey key, RegularAndStaticColumns columns, int nowInSec, WriteContext ctx, IndexTransaction.Type transactionType) {
                return null;
            }

            @Override
            public BiFunction<PartitionIterator, ReadCommand, PartitionIterator> postProcessorFor(ReadCommand command) {
                return null;
            }

            @Override
            public Index.Searcher searcherFor(ReadCommand command) {
                return null;
            }
        };

        @Override
        public void registerIndex(Index index) {
        }

        @Override
        public void unregisterIndex(Index index) {
        }

        @Override
        public Index getIndex(IndexMetadata indexMetadata) {
            return this.index;
        }

        @Override
        public Collection<Index> listIndexes() {
            return Collections.singletonList(this.index);
        }

        @Override
        public Optional<Index> getBestIndexFor(RowFilter.Expression expression) {
            return Optional.empty();
        }

        @Override
        public void validate(PartitionUpdate update) {
        }
    };

    public void registerIndex(Index var1);

    public void unregisterIndex(Index var1);

    public Index getIndex(IndexMetadata var1);

    public Collection<Index> listIndexes();

    public Optional<Index> getBestIndexFor(RowFilter.Expression var1);

    public void validate(PartitionUpdate var1);

    public static IndexRegistry obtain(TableMetadata table) {
        if (!DatabaseDescriptor.isDaemonInitialized()) {
            return NON_DAEMON;
        }
        return table.isVirtual() ? EMPTY : Keyspace.openAndGetStore((TableMetadata)table).indexManager;
    }
}

