/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.report;

import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public final class TimingInterval {
    private final Histogram responseTime = new Histogram(3);
    private final Histogram serviceTime = new Histogram(3);
    private final Histogram waitTime = new Histogram(3);
    public static final long[] EMPTY_SAMPLE = new long[0];
    private long startNs = Long.MAX_VALUE;
    private long endNs = Long.MIN_VALUE;
    public long partitionCount;
    public long rowCount;
    public long errorCount;
    public final boolean isFixed;

    public TimingInterval(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public String toString() {
        return String.format("Start: %d end: %d maxLatency: %d pCount: %d rcount: %d opCount: %d errors: %d", this.startNs, this.endNs, this.getLatencyHistogram().getMaxValue(), this.partitionCount, this.rowCount, this.getLatencyHistogram().getTotalCount(), this.errorCount);
    }

    public double opRate() {
        return (double)this.getLatencyHistogram().getTotalCount() / ((double)(this.endNs - this.startNs) * 1.0E-9);
    }

    public double adjustedRowRate() {
        return (double)this.rowCount / ((double)(this.endNs - (this.startNs + this.getLatencyHistogram().getMaxValue())) * 1.0E-9);
    }

    public double partitionRate() {
        return (double)this.partitionCount / ((double)(this.endNs - this.startNs) * 1.0E-9);
    }

    public double rowRate() {
        return (double)this.rowCount / ((double)(this.endNs - this.startNs) * 1.0E-9);
    }

    public double meanLatencyMs() {
        return this.getLatencyHistogram().getMean() * 1.0E-6;
    }

    public double maxLatencyMs() {
        return (double)this.getLatencyHistogram().getMaxValue() * 1.0E-6;
    }

    public double medianLatencyMs() {
        return (double)this.getLatencyHistogram().getValueAtPercentile(50.0) * 1.0E-6;
    }

    public double latencyAtPercentileMs(double percentile) {
        return (double)this.getLatencyHistogram().getValueAtPercentile(percentile) * 1.0E-6;
    }

    public long runTimeMs() {
        return (this.endNs - this.startNs) / 1000000L;
    }

    public long endNanos() {
        return this.endNs;
    }

    public long startNanos() {
        return this.startNs;
    }

    public Histogram responseTime() {
        return this.responseTime;
    }

    public Histogram serviceTime() {
        return this.serviceTime;
    }

    public Histogram waitTime() {
        return this.waitTime;
    }

    private Histogram getLatencyHistogram() {
        if (!this.isFixed || this.responseTime.getTotalCount() == 0L) {
            return this.serviceTime;
        }
        return this.responseTime;
    }

    String getStringValue(TimingParameter value) {
        return this.getStringValue(value, Double.NaN);
    }

    String getStringValue(TimingParameter value, double rank) {
        switch (value) {
            case OPRATE: {
                return String.format("%,.0f", this.opRate());
            }
            case ROWRATE: {
                return String.format("%,.0f", this.rowRate());
            }
            case ADJROWRATE: {
                return String.format("%,.0f", this.adjustedRowRate());
            }
            case PARTITIONRATE: {
                return String.format("%,.0f", this.partitionRate());
            }
            case MEANLATENCY: {
                return String.format("%,.1f", this.meanLatencyMs());
            }
            case MAXLATENCY: {
                return String.format("%,.1f", this.maxLatencyMs());
            }
            case MEDIANLATENCY: {
                return String.format("%,.1f", this.medianLatencyMs());
            }
            case RANKLATENCY: {
                return String.format("%,.1f", this.latencyAtPercentileMs(rank));
            }
            case ERRORCOUNT: {
                return String.format("%,d", this.errorCount);
            }
            case PARTITIONCOUNT: {
                return String.format("%,d", this.partitionCount);
            }
        }
        throw new IllegalStateException();
    }

    public long operationCount() {
        return this.getLatencyHistogram().getTotalCount();
    }

    public void startNanos(long started) {
        this.startNs = started;
    }

    public void endNanos(long ended) {
        this.endNs = ended;
    }

    public void reset() {
        this.endNs = Long.MIN_VALUE;
        this.startNs = Long.MAX_VALUE;
        this.errorCount = 0L;
        this.rowCount = 0L;
        this.partitionCount = 0L;
        if (this.responseTime.getTotalCount() != 0L) {
            this.responseTime.reset();
        }
        if (this.serviceTime.getTotalCount() != 0L) {
            this.serviceTime.reset();
        }
        if (this.waitTime.getTotalCount() != 0L) {
            this.waitTime.reset();
        }
    }

    public void add(TimingInterval value) {
        if (this.startNs > value.startNs) {
            this.startNs = value.startNs;
        }
        if (this.endNs < value.endNs) {
            this.endNs = value.endNs;
        }
        this.errorCount += value.errorCount;
        this.rowCount += value.rowCount;
        this.partitionCount += value.partitionCount;
        if (value.responseTime.getTotalCount() != 0L) {
            this.responseTime.add((AbstractHistogram)value.responseTime);
        }
        if (value.serviceTime.getTotalCount() != 0L) {
            this.serviceTime.add((AbstractHistogram)value.serviceTime);
        }
        if (value.waitTime.getTotalCount() != 0L) {
            this.waitTime.add((AbstractHistogram)value.waitTime);
        }
    }

    public static enum TimingParameter {
        OPRATE,
        ROWRATE,
        ADJROWRATE,
        PARTITIONRATE,
        MEANLATENCY,
        MAXLATENCY,
        MEDIANLATENCY,
        RANKLATENCY,
        ERRORCOUNT,
        PARTITIONCOUNT;

    }
}

