/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.listeners;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.github.jamm.MemoryMeterListener;

public final class TreePrinter
implements MemoryMeterListener {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private final Map<Object, ObjectInfo> mapping = new IdentityHashMap<Object, ObjectInfo>();
    private final int maxDepth;
    private boolean hasMissingElements;
    private Object root;

    public TreePrinter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public void started(Object obj) {
        this.root = obj;
        this.mapping.put(obj, ObjectInfo.newRoot(obj.getClass()));
    }

    @Override
    public void fieldAdded(Object obj, String fieldName, Object fieldValue) {
        ObjectInfo parent = this.mapping.get(obj);
        if (parent != null && parent.depth <= this.maxDepth - 1) {
            ObjectInfo field = parent.addChild(fieldName, fieldValue.getClass());
            this.mapping.put(fieldValue, field);
        } else {
            this.hasMissingElements = true;
        }
    }

    @Override
    public void arrayElementAdded(Object[] array, int index, Object elementValue) {
        this.fieldAdded(array, Integer.toString(index), elementValue);
    }

    @Override
    public void objectMeasured(Object current, long size) {
        ObjectInfo field = this.mapping.get(current);
        if (field != null) {
            field.size = size;
        }
    }

    @Override
    public void byteBufferRemainingMeasured(ByteBuffer buffer, long size) {
        ObjectInfo field = this.mapping.get(buffer);
        if (field != null) {
            ObjectInfo objectInfo = field;
            objectInfo.size = objectInfo.size + size;
        }
    }

    @Override
    public void done(long size) {
        System.out.println(this.mapping.get(this.root).toString(!this.hasMissingElements));
    }

    @Override
    public void failedToAccessField(Object obj, String fieldName, Class<?> fieldType) {
        String fieldTypeName = ObjectInfo.className(fieldType);
        StringBuilder builder = new StringBuilder("The value of the ").append(fieldName).append(" field from ").append(fieldTypeName).append(" could not be retrieved. Dependency stack below: ").append(LINE_SEPARATOR);
        builder.append(fieldName).append(" [").append(fieldTypeName).append("] ");
        ObjectInfo parent = this.mapping.get(obj);
        while (parent != null) {
            builder.append(LINE_SEPARATOR).append('|').append(LINE_SEPARATOR);
            parent.appendNameAndClassName(builder);
            parent = parent.parent;
        }
        System.err.println(builder);
    }

    public static class Factory
    implements MemoryMeterListener.Factory {
        private final int maxDepth;

        public Factory(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public MemoryMeterListener newInstance() {
            return new TreePrinter(this.maxDepth);
        }
    }

    private static final class ObjectInfo {
        private static final String ROOT_NAME = "#root";
        private final String name;
        private final String className;
        private final int depth;
        private final ObjectInfo parent;
        private List<ObjectInfo> children = Collections.emptyList();
        private long size;
        private long totalSize = -1L;

        public ObjectInfo(ObjectInfo parent, String name, Class<?> clazz, int depth) {
            this.parent = parent;
            this.name = name;
            this.className = ObjectInfo.className(clazz);
            this.depth = depth;
        }

        public static ObjectInfo newRoot(Class<?> clazz) {
            return new ObjectInfo(null, ROOT_NAME, clazz, 0);
        }

        public ObjectInfo addChild(String childName, Class<?> childClass) {
            ObjectInfo child = new ObjectInfo(this, childName, childClass, this.depth + 1);
            if (this.children.isEmpty()) {
                this.children = new ArrayList<ObjectInfo>();
            }
            this.children.add(child);
            return child;
        }

        public long totalSize() {
            if (this.totalSize < 0L) {
                this.totalSize = this.computeTotalSize();
            }
            return this.totalSize;
        }

        private long computeTotalSize() {
            long total = this.size;
            for (ObjectInfo child : this.children) {
                total += child.totalSize();
            }
            return total;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean printTotalSize) {
            return this.append("", true, printTotalSize, new StringBuilder().append(LINE_SEPARATOR).append(LINE_SEPARATOR)).toString();
        }

        private StringBuilder append(String indentation, boolean isLast, boolean printTotalSize, StringBuilder builder) {
            if (this.name != ROOT_NAME) {
                builder.append(indentation).append('|').append(LINE_SEPARATOR).append(indentation).append("+--");
            }
            this.appendNameAndClassName(builder);
            if (this.size != 0L) {
                if (printTotalSize) {
                    ObjectInfo.appendSizeTo(builder, this.totalSize());
                    builder.append(' ');
                }
                builder.append('(');
                ObjectInfo.appendSizeTo(builder, this.size);
                builder.append(')');
            }
            return this.appendChildren(ObjectInfo.childIndentation(indentation, isLast), printTotalSize, builder.append(LINE_SEPARATOR));
        }

        public StringBuilder appendNameAndClassName(StringBuilder builder) {
            return builder.append(this.name.equals(ROOT_NAME) ? "root" : this.name).append(" [").append(this.className).append("] ");
        }

        private StringBuilder appendChildren(String indentation, boolean printTotalSize, StringBuilder builder) {
            int m = this.children.size();
            for (int i = 0; i < m; ++i) {
                ObjectInfo child = this.children.get(i);
                boolean isLast = i == m - 1;
                child.append(indentation, isLast, printTotalSize, builder);
            }
            return builder;
        }

        private static String childIndentation(String indentation, boolean isLast) {
            return isLast ? indentation + "  " : indentation + "|  ";
        }

        public static String className(Class<?> clazz) {
            if (clazz.isArray()) {
                return clazz.getComponentType().getName() + "[]";
            }
            return clazz.getName();
        }

        private static void appendSizeTo(StringBuilder builder, long size) {
            if (size >= 0x100000L) {
                builder.append(String.format("%.2f", (double)size / 1048576.0)).append(" KB");
            } else if (size >= 1024L) {
                builder.append(String.format("%.2f", (double)size / 1024.0)).append(" KB");
            } else {
                builder.append(size).append(" bytes");
            }
        }
    }
}

