/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.numbersystrem;

import org.psjava.ds.numbersystrem.IntegerDivisableNumberSystem;
import org.psjava.ds.numbersystrem.MultipliableNumberSystem;
import org.psjava.formula.Modulo;

public class ModularNumberSystem<T>
implements MultipliableNumberSystem<T> {
    private final IntegerDivisableNumberSystem<T> ns;
    private final T m;

    public static <T> ModularNumberSystem<T> newInstance(IntegerDivisableNumberSystem<T> originalSystem, T modular) {
        return new ModularNumberSystem<T>(originalSystem, modular);
    }

    private ModularNumberSystem(IntegerDivisableNumberSystem<T> originalSystem, T modular) {
        this.ns = originalSystem;
        this.m = modular;
    }

    @Override
    public T getZero() {
        return this.ns.getZero();
    }

    @Override
    public T getOne() {
        return this.ns.getOne();
    }

    @Override
    public T getByInt(int v) {
        return this.modulo(this.ns.getByInt(v));
    }

    @Override
    public boolean isOne(T v) {
        return this.ns.isOne(this.modulo(v));
    }

    @Override
    public boolean isPositive(T v) {
        return this.ns.isPositive(this.modulo(v));
    }

    @Override
    public boolean isNegative(T v) {
        return false;
    }

    @Override
    public boolean isZero(T v) {
        return this.ns.isZero(this.modulo(v));
    }

    @Override
    public int getSign(T v) {
        return this.ns.getSign(this.modulo(v));
    }

    @Override
    public boolean areEqual(T v1, T v2) {
        return this.ns.areEqual(this.modulo(v1), this.modulo(v2));
    }

    @Override
    public T add(T v1, T v2) {
        return this.modulo(this.ns.add(v1, v2));
    }

    @Override
    public T subtract(T minuend, T subtrahend) {
        return this.modulo(this.ns.subtract(minuend, subtrahend));
    }

    @Override
    public T multiply(T v1, T v2) {
        return this.modulo(this.ns.multiply(v1, v2));
    }

    private T modulo(T v) {
        return Modulo.calc(this.ns, v, this.m);
    }

    @Override
    public int compare(T o1, T o2) {
        return this.ns.compare(this.modulo(o1), this.modulo(o2));
    }
}

