/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.binary;

import org.psjava.ds.tree.binary.BinaryTreeNodeWithParent;
import org.psjava.util.AssertStatus;

public class BinaryTreeNodeWithParentFactory {
    public static <T> BinaryTreeNodeWithParent<T> create(final T initData) {
        return new BinaryTreeNodeWithParent<T>(){
            T data;
            BinaryTreeNodeWithParent<T> parentOrNull;
            BinaryTreeNodeWithParent<T> leftOrNull;
            BinaryTreeNodeWithParent<T> rightOrNull;
            {
                this.data = initData;
                this.leftOrNull = null;
                this.rightOrNull = null;
            }

            @Override
            public T getData() {
                return this.data;
            }

            @Override
            public void setData(T data) {
                this.data = data;
            }

            @Override
            public boolean hasParent() {
                return this.parentOrNull != null;
            }

            @Override
            public BinaryTreeNodeWithParent<T> getParent() {
                AssertStatus.assertTrue(this.hasParent());
                return this.parentOrNull;
            }

            @Override
            public void removeParent() {
                AssertStatus.assertTrue(this.parentOrNull != null);
                this.parentOrNull = null;
            }

            @Override
            public void putParent(BinaryTreeNodeWithParent<T> parent) {
                AssertStatus.assertTrue(parent != null);
                this.parentOrNull = parent;
            }

            @Override
            public boolean hasLeft() {
                return this.leftOrNull != null;
            }

            @Override
            public boolean hasRight() {
                return this.rightOrNull != null;
            }

            @Override
            public BinaryTreeNodeWithParent<T> getLeft() {
                AssertStatus.assertTrue(this.hasLeft());
                return this.leftOrNull;
            }

            @Override
            public BinaryTreeNodeWithParent<T> getRight() {
                AssertStatus.assertTrue(this.hasRight());
                return this.rightOrNull;
            }

            @Override
            public void putLeft(BinaryTreeNodeWithParent<T> child) {
                this.leftOrNull = child;
            }

            @Override
            public void putRight(BinaryTreeNodeWithParent<T> child) {
                this.rightOrNull = child;
            }

            @Override
            public void removeLeft() {
                AssertStatus.assertTrue(this.hasLeft());
                this.leftOrNull = null;
            }

            @Override
            public void removeRight() {
                AssertStatus.assertTrue(this.hasRight());
                this.rightOrNull = null;
            }
        };
    }

    private BinaryTreeNodeWithParentFactory() {
    }
}

