/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.RoleResource;

public class Role {
    public final RoleResource resource;
    public final boolean isSuper;
    public final boolean canLogin;
    public final Set<String> memberOf;
    public final Map<String, String> options;

    public Role(String name, boolean isSuperUser, boolean canLogin, Map<String, String> options, Set<String> memberOf) {
        this.resource = RoleResource.role(name);
        this.isSuper = isSuperUser;
        this.canLogin = canLogin;
        this.memberOf = ImmutableSet.copyOf(memberOf);
        this.options = ImmutableMap.copyOf(options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role r = (Role)o;
        return Objects.equal((Object)this.resource, (Object)r.resource) && Objects.equal((Object)this.isSuper, (Object)r.isSuper) && Objects.equal((Object)this.canLogin, (Object)r.canLogin) && Objects.equal(this.memberOf, r.memberOf) && Objects.equal(this.options, r.options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resource, this.isSuper, this.canLogin, this.memberOf, this.options});
    }
}

