/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBase;
import org.apache.cassandra.concurrent.ThreadPoolExecutorJMXAdapter;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.BlockingQueues;

final class UDFExecutorService
extends ThreadPoolExecutorBase {
    private static final int KEEPALIVE = CassandraRelevantProperties.UDF_EXECUTOR_THREAD_KEEPALIVE_MS.getInt();

    public UDFExecutorService(NamedThreadFactory threadFactory, String jmxPath) {
        super(FBUtilities.getAvailableProcessors(), KEEPALIVE, TimeUnit.MILLISECONDS, BlockingQueues.newBlockingQueue(), threadFactory);
        ThreadPoolExecutorJMXAdapter.register(jmxPath, this);
    }

    @Override
    public int getCoreThreads() {
        return this.getCorePoolSize();
    }

    @Override
    public void setCoreThreads(int newCorePoolSize) {
        this.setCorePoolSize(newCorePoolSize);
    }

    @Override
    public int getMaximumThreads() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaximumThreads(int maxPoolSize) {
        this.setMaximumPoolSize(maxPoolSize);
    }
}

