/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.masking;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.masking.MaskingFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.StringUtils;

public class PartialMaskingFunction
extends MaskingFunction {
    public static final char DEFAULT_PADDING_CHAR = '*';
    private final Kind kind;
    private final AbstractType<String> inputType;
    private final ArgumentDeserializer paddingArgumentDeserializer;

    private PartialMaskingFunction(FunctionName name, Kind kind, AbstractType<String> inputType, boolean hasPaddingArgument) {
        super(name, inputType, inputType, PartialMaskingFunction.argumentsType(hasPaddingArgument));
        this.kind = kind;
        this.inputType = inputType;
        this.paddingArgumentDeserializer = (version, buffer) -> {
            if (buffer == null || !hasPaddingArgument) {
                return null;
            }
            String arg = (String)UTF8Type.instance.compose(buffer);
            if (arg.length() != 1) {
                throw new InvalidRequestException(String.format("The padding argument for function %s should be single-character, but '%s' has %d characters.", name, arg, arg.length()));
            }
            return Character.valueOf(arg.charAt(0));
        };
    }

    private static AbstractType<?>[] argumentsType(boolean hasPaddingArgument) {
        AbstractType[] abstractTypeArray;
        if (hasPaddingArgument) {
            AbstractType[] abstractTypeArray2 = new AbstractType[3];
            abstractTypeArray2[0] = Int32Type.instance;
            abstractTypeArray2[1] = Int32Type.instance;
            abstractTypeArray = abstractTypeArray2;
            abstractTypeArray2[2] = UTF8Type.instance;
        } else {
            AbstractType[] abstractTypeArray3 = new AbstractType[2];
            abstractTypeArray3[0] = Int32Type.instance;
            abstractTypeArray = abstractTypeArray3;
            abstractTypeArray3[1] = Int32Type.instance;
        }
        return abstractTypeArray;
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return new FunctionArguments(version, this.inputType.getArgumentDeserializer(), Int32Type.instance.getArgumentDeserializer(), Int32Type.instance.getArgumentDeserializer(), this.paddingArgumentDeserializer);
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        String value = (String)arguments.get(0);
        if (value == null) {
            return null;
        }
        int begin = arguments.get(1) != null ? arguments.getAsInt(1) : 0;
        int end = arguments.get(2) != null ? arguments.getAsInt(2) : 0;
        char padding = arguments.get(3) == null ? (char)'*' : (char)((Character)arguments.get(3)).charValue();
        String maskedValue = this.kind.mask(value, begin, end, padding);
        return this.inputType.decompose(maskedValue);
    }

    public static Collection<FunctionFactory> factories() {
        return Stream.of(Kind.values()).map(PartialMaskingFunction::factory).collect(Collectors.toSet());
    }

    private static FunctionFactory factory(final Kind kind) {
        return new MaskingFunction.Factory(kind.name(), new FunctionParameter[]{FunctionParameter.string(), FunctionParameter.fixed(CQL3Type.Native.INT), FunctionParameter.fixed(CQL3Type.Native.INT), FunctionParameter.optional(FunctionParameter.fixed(CQL3Type.Native.TEXT))}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                AbstractType<String> inputType = argTypes.get(0);
                return new PartialMaskingFunction(this.name, kind, inputType, argTypes.size() == 4);
            }
        };
    }

    public static enum Kind {
        INNER{

            @Override
            protected boolean shouldMask(int pos, int begin, int end) {
                return pos >= begin && pos <= end;
            }
        }
        ,
        OUTER{

            @Override
            protected boolean shouldMask(int pos, int begin, int end) {
                return pos < begin || pos > end;
            }
        };


        protected abstract boolean shouldMask(int var1, int var2, int var3);

        @VisibleForTesting
        public String mask(String value, int begin, int end, char padding) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            int size = value.length();
            int endIndex = size - 1 - end;
            char[] chars = new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = this.shouldMask(i, begin, endIndex) ? padding : value.charAt(i);
            }
            return new String(chars);
        }
    }
}

