/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class RoleManagementStatement
extends AuthenticationStatement {
    protected final RoleResource role;
    protected final RoleResource grantee;

    public RoleManagementStatement(RoleName name, RoleName grantee) {
        this.role = RoleResource.role(name.getName());
        this.grantee = RoleResource.role(grantee.getName());
    }

    @Override
    public void authorize(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.AUTHORIZE, this.role);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.role.getRoleName()));
        }
        if (!DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.grantee.getRoleName()));
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

