/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.triggers.TriggerExecutor;

public final class CreateTriggerStatement
extends AlterSchemaStatement {
    private final String tableName;
    private final String triggerName;
    private final String triggerClass;
    private final boolean ifNotExists;

    public CreateTriggerStatement(String keyspaceName, String tableName, String triggerName, String triggerClass, boolean ifNotExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.triggerName = triggerName;
        this.triggerClass = triggerClass;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateTriggerStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        TableMetadata table = keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            throw CreateTriggerStatement.ire("Table '%s' doesn't exist", this.tableName);
        }
        if (table.isView()) {
            throw CreateTriggerStatement.ire("Cannot CREATE TRIGGER for a materialized view", new Object[0]);
        }
        TriggerMetadata existingTrigger = table.triggers.get(this.triggerName).orElse(null);
        if (null != existingTrigger) {
            if (this.ifNotExists) {
                return schema;
            }
            throw CreateTriggerStatement.ire("Trigger '%s' already exists", this.triggerName);
        }
        try {
            TriggerExecutor.instance.loadTriggerInstance(this.triggerClass);
        }
        catch (Exception e) {
            throw CreateTriggerStatement.ire("Trigger class '%s' couldn't be loaded", this.triggerClass);
        }
        TableMetadata newTable = table.withSwapped(table.triggers.with(TriggerMetadata.create(this.triggerName, this.triggerClass)));
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.withSwapped(newTable)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureIsSuperuser("Only superusers are allowed to perform CREATE TRIGGER queries");
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_TRIGGER, this.keyspaceName, this.triggerName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.triggerName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName tableName;
        private final String triggerName;
        private final String triggerClass;
        private final boolean ifNotExists;

        public Raw(QualifiedName tableName, String triggerName, String triggerClass, boolean ifNotExists) {
            this.tableName = tableName;
            this.triggerName = triggerName;
            this.triggerClass = triggerClass;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateTriggerStatement prepare(ClientState state) {
            String keyspaceName = this.tableName.hasKeyspace() ? this.tableName.getKeyspace() : state.getKeyspace();
            return new CreateTriggerStatement(keyspaceName, this.tableName.getName(), this.triggerName, this.triggerClass, this.ifNotExists);
        }
    }
}

