/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapCloner;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.NativeAllocator;
import org.apache.cassandra.utils.memory.NativeEndianMemoryUtil;

public class NativeClustering
implements Clustering<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new NativeClustering());
    private final long peer;

    private NativeClustering() {
        this.peer = 0L;
    }

    public NativeClustering(NativeAllocator allocator, OpOrder.Group writeOp, Clustering<?> clustering) {
        int count = clustering.size();
        int metadataSize = count * 2 + 4;
        int dataSize = clustering.dataSize();
        int bitmapSize = count + 7 >>> 3;
        assert (count < 65536);
        assert (dataSize <= 65535) : String.format("Data size %d >= %d", dataSize, 65536);
        this.peer = allocator.allocate(metadataSize + dataSize + bitmapSize, writeOp);
        long bitmapStart = this.peer + (long)metadataSize;
        NativeEndianMemoryUtil.setShort(this.peer, (short)count);
        NativeEndianMemoryUtil.setShort(this.peer + (long)(metadataSize - 2), (short)dataSize);
        NativeEndianMemoryUtil.setByte(bitmapStart, bitmapSize, (byte)0);
        long dataStart = this.peer + (long)metadataSize + (long)bitmapSize;
        int dataOffset = 0;
        for (int i = 0; i < count; ++i) {
            NativeEndianMemoryUtil.setShort(this.peer + 2L + (long)(i * 2), (short)dataOffset);
            ByteBuffer value = clustering.bufferAt(i);
            if (value == null) {
                long boffset = bitmapStart + (long)(i >>> 3);
                int b = NativeEndianMemoryUtil.getByte(boffset);
                NativeEndianMemoryUtil.setByte(boffset, (byte)(b |= 1 << (i & 7)));
                continue;
            }
            assert (value.order() == ByteOrder.BIG_ENDIAN);
            int size = value.remaining();
            NativeEndianMemoryUtil.setBytes(dataStart + (long)dataOffset, value);
            dataOffset += size;
        }
    }

    @Override
    public ClusteringPrefix.Kind kind() {
        return ClusteringPrefix.Kind.CLUSTERING;
    }

    @Override
    public ClusteringPrefix<ByteBuffer> clustering() {
        return this;
    }

    @Override
    public int size() {
        return NativeEndianMemoryUtil.getUnsignedShort(this.peer);
    }

    @Override
    public int dataSize() {
        int dataSizeOffset = this.size() * 2 + 2;
        return NativeEndianMemoryUtil.getUnsignedShort(this.peer + (long)dataSizeOffset);
    }

    @Override
    public ByteBuffer get(int i) {
        int size = this.size();
        if (i >= size) {
            throw new IndexOutOfBoundsException();
        }
        int metadataSize = size * 2 + 4;
        int bitmapSize = size + 7 >>> 3;
        long bitmapStart = this.peer + (long)metadataSize;
        byte b = NativeEndianMemoryUtil.getByte(bitmapStart + (long)(i >>> 3));
        if ((b & 1 << (i & 7)) != 0) {
            return null;
        }
        int startOffset = NativeEndianMemoryUtil.getUnsignedShort(this.peer + 2L + (long)(i * 2));
        int endOffset = NativeEndianMemoryUtil.getUnsignedShort(this.peer + 4L + (long)(i * 2));
        return MemoryUtil.getByteBuffer(bitmapStart + (long)bitmapSize + (long)startOffset, endOffset - startOffset, ByteOrder.BIG_ENDIAN);
    }

    public ByteBuffer[] getRawValues() {
        ByteBuffer[] values = new ByteBuffer[this.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.get(i);
        }
        return values;
    }

    @Override
    public ByteBuffer[] getBufferArray() {
        return this.getRawValues();
    }

    @Override
    public ValueAccessor<ByteBuffer> accessor() {
        return ByteBufferAccessor.instance;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE;
    }

    public final int hashCode() {
        return ClusteringPrefix.hashCode(this);
    }

    public final boolean equals(Object o) {
        return ClusteringPrefix.equals(this, o);
    }

    @Override
    public ClusteringPrefix<ByteBuffer> retainable() {
        assert (this.kind() == ClusteringPrefix.Kind.CLUSTERING);
        ByteBuffer[] values = new ByteBuffer[this.size()];
        for (int i = 0; i < values.length; ++i) {
            ByteBuffer value = this.get(i);
            values[i] = value != null ? HeapCloner.instance.clone(value) : null;
        }
        return this.accessor().factory().clustering((ByteBuffer[])values);
    }
}

