/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.ShardManagerNoDisks;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;

public class ShardManagerDiskAware
extends ShardManagerNoDisks {
    private final double[] diskBoundaryPositions;
    private final int[] diskStartRangeIndex;
    private final List<Token> diskBoundaries;

    public ShardManagerDiskAware(ColumnFamilyStore.VersionedLocalRanges localRanges, List<Token> diskBoundaries) {
        super(localRanges);
        assert (diskBoundaries != null && !diskBoundaries.isEmpty());
        this.diskBoundaries = diskBoundaries;
        double position = 0.0;
        ColumnFamilyStore.VersionedLocalRanges ranges = localRanges;
        int diskIndex = 0;
        this.diskBoundaryPositions = new double[diskBoundaries.size()];
        this.diskStartRangeIndex = new int[this.diskBoundaryPositions.length];
        this.diskStartRangeIndex[0] = 0;
        for (int i = 0; i < this.localRangePositions.length; ++i) {
            Range<Token> range = ((Splitter.WeightedRange)ranges.get(i)).range();
            double weight = ((Splitter.WeightedRange)ranges.get(i)).weight();
            double span = this.localRangePositions[i] - position;
            Token diskBoundary = diskBoundaries.get(diskIndex);
            while (diskIndex < this.diskBoundaryPositions.length - 1 && (((Token)range.right).isMinimum() || diskBoundary.compareTo((Token)range.right) < 0)) {
                double leftPart = ((Token)range.left).size(diskBoundary) * weight;
                if (leftPart > span) {
                    leftPart = 0.0;
                }
                this.diskBoundaryPositions[diskIndex] = position + leftPart;
                this.diskStartRangeIndex[diskIndex + 1] = i;
                diskBoundary = diskBoundaries.get(++diskIndex);
            }
            position += span;
        }
        this.diskBoundaryPositions[diskIndex] = position;
        assert (diskIndex + 1 == this.diskBoundaryPositions.length) : "Disk boundaries are not within local ranges";
    }

    @Override
    public double shardSetCoverage() {
        return this.localSpaceCoverage() / (double)this.diskBoundaryPositions.length;
    }

    @Override
    public ShardTracker boundaries(int shardCount) {
        return new BoundaryTrackerDiskAware(shardCount);
    }

    public class BoundaryTrackerDiskAware
    implements ShardTracker {
        private final int countPerDisk;
        private double shardStep;
        private double diskStart;
        private int diskIndex;
        private int nextShardIndex;
        private int currentRange;
        private Token currentStart;
        @Nullable
        private Token currentEnd;

        public BoundaryTrackerDiskAware(int countPerDisk) {
            this.countPerDisk = countPerDisk;
            this.currentStart = ((Splitter.WeightedRange)ShardManagerDiskAware.this.localRanges.get(0)).left();
            this.diskIndex = -1;
        }

        void enterDisk(int diskIndex) {
            this.diskIndex = diskIndex;
            this.currentRange = 0;
            this.diskStart = diskIndex > 0 ? ShardManagerDiskAware.this.diskBoundaryPositions[diskIndex - 1] : 0.0;
            this.shardStep = (ShardManagerDiskAware.this.diskBoundaryPositions[diskIndex] - this.diskStart) / (double)this.countPerDisk;
            this.nextShardIndex = 1;
        }

        private Token getEndToken(double toPos) {
            double left = this.currentRange > 0 ? ShardManagerDiskAware.this.localRangePositions[this.currentRange - 1] : 0.0;
            double right = ShardManagerDiskAware.this.localRangePositions[this.currentRange];
            while (toPos > right) {
                left = right;
                right = ShardManagerDiskAware.this.localRangePositions[++this.currentRange];
            }
            Range<Token> range = ((Splitter.WeightedRange)ShardManagerDiskAware.this.localRanges.get(this.currentRange)).range();
            return this.currentStart.getPartitioner().split((Token)range.left, (Token)range.right, (toPos - left) / (right - left));
        }

        @Override
        public Token shardStart() {
            return this.currentStart;
        }

        @Override
        public Token shardEnd() {
            return this.currentEnd;
        }

        @Override
        public Range<Token> shardSpan() {
            return new Range<Token>(this.currentStart, this.currentEnd != null ? this.currentEnd : this.currentStart.minValue());
        }

        @Override
        public double shardSpanSize() {
            return this.shardStep;
        }

        @Override
        public boolean advanceTo(Token nextToken) {
            if (this.diskIndex < 0) {
                int search = Collections.binarySearch(ShardManagerDiskAware.this.diskBoundaries, nextToken);
                if (search < 0) {
                    search = -1 - search;
                }
                this.enterDisk(search);
                this.setEndToken();
            }
            if (this.currentEnd == null || nextToken.compareTo(this.currentEnd) <= 0) {
                return false;
            }
            do {
                this.currentStart = this.currentEnd;
                if (this.nextShardIndex == this.countPerDisk) {
                    this.enterDisk(this.diskIndex + 1);
                } else {
                    ++this.nextShardIndex;
                }
                this.setEndToken();
            } while (this.currentEnd != null && nextToken.compareTo(this.currentEnd) > 0);
            return true;
        }

        private void setEndToken() {
            this.currentEnd = this.nextShardIndex == this.countPerDisk ? (this.diskIndex + 1 == ShardManagerDiskAware.this.diskBoundaryPositions.length ? null : ShardManagerDiskAware.this.diskBoundaries.get(this.diskIndex)) : this.getEndToken(this.diskStart + this.shardStep * (double)this.nextShardIndex);
        }

        @Override
        public int count() {
            return this.countPerDisk;
        }

        @Override
        public double fractionInShard(Range<Token> targetSpan) {
            Range<Token> shardSpan = this.shardSpan();
            Range<Token> covered = targetSpan.intersectionNonWrapping(shardSpan);
            if (covered == null) {
                return 0.0;
            }
            if (covered == targetSpan) {
                return 1.0;
            }
            double inShardSize = covered == shardSpan ? this.shardSpanSize() : ShardManagerDiskAware.this.rangeSpanned(covered);
            double totalSize = ShardManagerDiskAware.this.rangeSpanned(targetSpan);
            return inShardSize / totalSize;
        }

        @Override
        public double rangeSpanned(PartitionPosition first, PartitionPosition last) {
            return ShardManagerDiskAware.this.rangeSpanned(first, last);
        }

        @Override
        public int shardIndex() {
            return this.nextShardIndex - 1;
        }
    }
}

