/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.cassandra.db.guardrails.Guardrail;
import org.apache.cassandra.service.ClientState;

public abstract class Threshold
extends Guardrail {
    protected ToLongFunction<ClientState> warnThreshold;
    protected ToLongFunction<ClientState> failThreshold;
    protected final ErrorMessageProvider messageProvider;

    public Threshold(String name, @Nullable String reason, ToLongFunction<ClientState> warnThreshold, ToLongFunction<ClientState> failThreshold, ErrorMessageProvider messageProvider) {
        super(name, reason);
        this.warnThreshold = warnThreshold;
        this.failThreshold = failThreshold;
        this.messageProvider = messageProvider;
    }

    protected abstract boolean compare(long var1, long var3);

    protected String errMsg(boolean isWarning, String what, long value, long thresholdValue) {
        return this.messageProvider.createMessage(isWarning, what, Long.toString(value), Long.toString(thresholdValue));
    }

    private String redactedErrMsg(boolean isWarning, long value, long thresholdValue) {
        return this.errMsg(isWarning, "<redacted>", value, thresholdValue);
    }

    protected abstract long failValue(ClientState var1);

    protected abstract long warnValue(ClientState var1);

    @Override
    public boolean enabled(@Nullable ClientState state) {
        if (!super.enabled(state)) {
            return false;
        }
        return this.failThreshold.applyAsLong(state) > 0L || this.warnThreshold.applyAsLong(state) > 0L;
    }

    public boolean triggersOn(long value, @Nullable ClientState state) {
        return this.enabled(state) && (this.compare(value, this.warnValue(state)) || this.compare(value, this.failValue(state)));
    }

    public boolean warnsOn(long value, @Nullable ClientState state) {
        return this.enabled(state) && this.compare(value, this.warnValue(state));
    }

    public boolean failsOn(long value, @Nullable ClientState state) {
        return this.enabled(state) && this.compare(value, this.failValue(state));
    }

    public void guard(long value, String what, boolean containsUserData, @Nullable ClientState state) {
        if (!this.enabled(state)) {
            return;
        }
        long failValue = this.failValue(state);
        if (this.compare(value, failValue)) {
            this.triggerFail(value, failValue, what, containsUserData, state);
            return;
        }
        long warnValue = this.warnValue(state);
        if (this.compare(value, warnValue)) {
            this.triggerWarn(value, warnValue, what, containsUserData);
        }
    }

    private void triggerFail(long value, long failValue, String what, boolean containsUserData, ClientState state) {
        String fullMessage = this.errMsg(false, what, value, failValue);
        this.fail(fullMessage, containsUserData ? this.redactedErrMsg(false, value, failValue) : fullMessage, state);
    }

    private void triggerWarn(long value, long warnValue, String what, boolean containsUserData) {
        String fullMessage = this.errMsg(true, what, value, warnValue);
        this.warn(fullMessage, containsUserData ? this.redactedErrMsg(true, value, warnValue) : fullMessage);
    }

    static interface ErrorMessageProvider {
        public String createMessage(boolean var1, String var2, String var3, String var4);
    }
}

