/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.commons.lang3.mutable.MutableLong;

public abstract class TemporalType<T>
extends AbstractType<T> {
    protected TemporalType(AbstractType.ComparisonType comparisonType) {
        super(comparisonType);
    }

    public ByteBuffer now() {
        return this.fromTimeInMillis(Clock.Global.currentTimeMillis());
    }

    public long toTimeInMillis(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer fromTimeInMillis(long timeInMillis) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer addDuration(Number temporal, Duration duration) {
        long timeInMillis = temporal.longValue();
        this.validateDuration(duration);
        return this.fromTimeInMillis(duration.addTo(timeInMillis));
    }

    public ByteBuffer substractDuration(Number temporal, Duration duration) {
        long timeInMillis = temporal.longValue();
        this.validateDuration(duration);
        return this.fromTimeInMillis(duration.substractFrom(timeInMillis));
    }

    protected void validateDuration(Duration duration) {
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return new ArgumentDeserializer(){
            private final MutableLong wrapper = new MutableLong();

            @Override
            public Object deserialize(ProtocolVersion protocolVersion, ByteBuffer buffer) {
                if (buffer == null || !buffer.hasRemaining() && TemporalType.this.isEmptyValueMeaningless()) {
                    return null;
                }
                this.wrapper.setValue(TemporalType.this.toTimeInMillis(buffer));
                return this.wrapper;
            }
        };
    }
}

