/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.gms.HeartBeatStateSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;

public class HeartBeatState {
    public static final int EMPTY_VERSION = -1;
    public static final IVersionedSerializer<HeartBeatState> serializer = new HeartBeatStateSerializer();
    private final int generation;
    private final int version;

    HeartBeatState(int gen) {
        this(gen, 0);
    }

    public HeartBeatState(HeartBeatState other) {
        this.generation = other.generation;
        this.version = other.version;
    }

    public HeartBeatState(int gen, int ver) {
        this.generation = gen;
        this.version = ver;
    }

    public static HeartBeatState empty() {
        return new HeartBeatState(0, -1);
    }

    public boolean isEmpty() {
        return this.version == -1;
    }

    public int getGeneration() {
        return this.generation;
    }

    HeartBeatState updateHeartBeat() {
        return new HeartBeatState(this.generation, VersionGenerator.getNextVersion());
    }

    public int getHeartBeatVersion() {
        return this.version;
    }

    HeartBeatState forceNewerGenerationUnsafe() {
        return new HeartBeatState(this.generation + 1, this.version);
    }

    HeartBeatState forceHighestPossibleVersionUnsafe() {
        return new HeartBeatState(this.generation, Integer.MAX_VALUE);
    }

    public String toString() {
        return String.format("HeartBeat: generation = %d, version = %d", this.generation, this.version);
    }
}

