/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.hints.HintsCatalog;
import org.apache.cassandra.hints.HintsDispatchExecutor;
import org.apache.cassandra.hints.HintsStore;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HintsCleanupTrigger
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HintsCleanupTrigger.class);
    private final HintsCatalog hintsCatalog;
    private final HintsDispatchExecutor dispatchExecutor;

    HintsCleanupTrigger(HintsCatalog catalog, HintsDispatchExecutor dispatchExecutor) {
        this.hintsCatalog = catalog;
        this.dispatchExecutor = dispatchExecutor;
    }

    @Override
    public void run() {
        if (!DatabaseDescriptor.isAutoHintsCleanupEnabled()) {
            return;
        }
        this.hintsCatalog.stores().filter(store -> StorageService.instance.getEndpointForHostId(store.hostId) == null).forEach(this::cleanup);
    }

    private void cleanup(HintsStore hintsStore) {
        logger.info("Found orphaned hints files for host: {}. Try to delete.", (Object)hintsStore.hostId);
        if (hintsStore.isWriting()) {
            hintsStore.closeWriter();
        }
        this.dispatchExecutor.interruptDispatch(hintsStore.hostId);
        Runnable cleanup = () -> hintsStore.deleteExpiredHints(Clock.Global.currentTimeMillis());
        ScheduledExecutors.optionalTasks.execute(cleanup);
    }
}

