/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.format;

import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.Component;

public enum IndexComponent {
    META("Meta"),
    BALANCED_TREE("BalancedTree"),
    TERMS_DATA("TermsData"),
    COMPRESSED_VECTORS("CompressedVectors"),
    POSTING_LISTS("PostingLists"),
    COLUMN_COMPLETION_MARKER("ColumnComplete"),
    ROW_TO_TOKEN("RowToToken"),
    ROW_TO_PARTITION("RowToPartition"),
    PARTITION_TO_SIZE("PartitionToSize"),
    PARTITION_KEY_BLOCKS("PartitionKeyBlocks"),
    PARTITION_KEY_BLOCK_OFFSETS("PartitionKeyBlockOffsets"),
    CLUSTERING_KEY_BLOCKS("ClusteringKeyBlocks"),
    CLUSTERING_KEY_BLOCK_OFFSETS("ClusteringKeyBlockOffsets"),
    GROUP_META("GroupMeta"),
    GROUP_COMPLETION_MARKER("GroupComplete");

    public final String name;
    public final Component.Type type;

    private IndexComponent(String name) {
        this.name = name;
        this.type = IndexComponent.componentType(name);
    }

    private static Component.Type componentType(String name) {
        String componentName = "SAI+" + name;
        String repr = Pattern.quote("SAI+") + ".*" + Pattern.quote("+" + name + ".db");
        return Component.Type.create(componentName, repr, true, null);
    }
}

