/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.trie;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.trie.TrieTermsDictionaryReader;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.io.tries.IncrementalDeepTrieWriterPageAware;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.commons.lang3.mutable.MutableLong;

@NotThreadSafe
public class TrieTermsDictionaryWriter
implements Closeable {
    private final IncrementalTrieWriter<Long> termsDictionaryWriter;
    private final IndexOutputWriter termDictionaryOutput;
    private final long startOffset;

    TrieTermsDictionaryWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
        this.termDictionaryOutput = indexDescriptor.openPerIndexOutput(IndexComponent.TERMS_DATA, indexIdentifier, true);
        this.startOffset = this.termDictionaryOutput.getFilePointer();
        SAICodecUtils.writeHeader(this.termDictionaryOutput);
        this.termsDictionaryWriter = new IncrementalDeepTrieWriterPageAware<Long>(TrieTermsDictionaryReader.trieSerializer, this.termDictionaryOutput.asSequentialWriter());
    }

    public void add(ByteComparable term, long postingListOffset) throws IOException {
        this.termsDictionaryWriter.add(term, postingListOffset);
    }

    @Override
    public void close() {
        this.termsDictionaryWriter.close();
        this.termDictionaryOutput.close();
    }

    public long complete(MutableLong footerPointer) throws IOException {
        long root = this.termsDictionaryWriter.complete();
        footerPointer.setValue(this.termDictionaryOutput.getFilePointer());
        SAICodecUtils.writeFooter(this.termDictionaryOutput);
        return root;
    }

    public long getFilePointer() {
        return this.termDictionaryOutput.getFilePointer();
    }

    public long getStartOffset() {
        return this.startOffset;
    }
}

