/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer;

import java.util.Map;

public class DelimiterTokenizingOptions {
    public static final String DELIMITER = "delimiter";
    private final char delimiter;

    private DelimiterTokenizingOptions(char delimiter) {
        this.delimiter = delimiter;
    }

    char getDelimiter() {
        return this.delimiter;
    }

    static DelimiterTokenizingOptions buildFromMap(Map<String, String> optionsMap) {
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            switch (entry.getKey()) {
                case "delimiter": {
                    String value = entry.getValue();
                    if (1 != value.length()) {
                        throw new IllegalArgumentException(String.format("Only single character delimiters supported, was %s", value));
                    }
                    optionsBuilder.delimiter = entry.getValue().charAt(0);
                    break;
                }
            }
        }
        return optionsBuilder.build();
    }

    private static class OptionsBuilder {
        private char delimiter = (char)44;

        private OptionsBuilder() {
        }

        public DelimiterTokenizingOptions build() {
            return new DelimiterTokenizingOptions(this.delimiter);
        }
    }
}

