/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.FilterComponent;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortedTableReaderLoadingBuilder<R extends SSTableReader, B extends SSTableReader.Builder<R, B>>
extends SSTableReaderLoadingBuilder<R, B> {
    private static final Logger logger = LoggerFactory.getLogger(SortedTableReaderLoadingBuilder.class);
    private FileHandle.Builder dataFileBuilder;

    public SortedTableReaderLoadingBuilder(SSTable.Builder<?, ?> builder) {
        super(builder);
    }

    protected IFilter loadFilter(ValidationMetadata validationMetadata) {
        return FilterComponent.maybeLoadBloomFilter(this.descriptor, this.components, this.tableMetadataRef.get(), validationMetadata);
    }

    protected FileHandle.Builder dataFileBuilder(StatsMetadata statsMetadata) {
        assert (this.dataFileBuilder == null || this.dataFileBuilder.file.equals(this.descriptor.fileFor(BtiFormat.Components.DATA)));
        logger.info("Opening {} ({})", (Object)this.descriptor, (Object)FBUtilities.prettyPrintMemory(this.descriptor.fileFor(BtiFormat.Components.DATA).length()));
        long recordSize = statsMetadata.estimatedPartitionSize.percentile(this.ioOptions.diskOptimizationEstimatePercentile);
        int bufferSize = this.ioOptions.diskOptimizationStrategy.bufferSize(recordSize);
        if (this.dataFileBuilder == null) {
            this.dataFileBuilder = new FileHandle.Builder(this.descriptor.fileFor(BtiFormat.Components.DATA));
        }
        this.dataFileBuilder.bufferSize(bufferSize);
        this.dataFileBuilder.withChunkCache(this.chunkCache);
        this.dataFileBuilder.mmapped(this.ioOptions.defaultDiskAccessMode);
        return this.dataFileBuilder;
    }
}

