/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

@NotThreadSafe
public class ValueIterator<CONCRETE extends ValueIterator<CONCRETE>>
extends Walker<CONCRETE> {
    private final ByteSource limit;
    private final Walker.TransitionBytesCollector collector;
    protected IterationPosition stack;
    private long next;

    protected ValueIterator(Rebufferer source, long root) {
        this(source, root, false);
    }

    protected ValueIterator(Rebufferer source, long root, boolean collecting) {
        super(source, root);
        this.limit = null;
        this.collector = collecting ? new Walker.TransitionBytesCollector() : null;
        this.initializeNoLeftBound(root, 256);
    }

    protected ValueIterator(Rebufferer source, long root, ByteComparable start, ByteComparable end, boolean admitPrefix) {
        this(source, root, start, end, admitPrefix, false);
    }

    protected ValueIterator(Rebufferer source, long root, ByteComparable start, ByteComparable end, boolean admitPrefix, boolean collecting) {
        super(source, root);
        this.limit = end != null ? end.asComparableBytes(BYTE_COMPARABLE_VERSION) : null;
        Walker.TransitionBytesCollector transitionBytesCollector = this.collector = collecting ? new Walker.TransitionBytesCollector() : null;
        if (start != null) {
            this.initializeWithLeftBound(root, start.asComparableBytes(BYTE_COMPARABLE_VERSION), admitPrefix, this.limit != null);
        } else {
            this.initializeNoLeftBound(root, this.limit != null ? this.limit.next() : 256);
        }
    }

    private void initializeWithLeftBound(long root, ByteSource startStream, boolean admitPrefix, boolean atLimit) {
        IterationPosition prev = null;
        long payloadedNode = -1L;
        try {
            int limitByte;
            int childIndex;
            this.go(root);
            while (true) {
                int s = startStream.next();
                childIndex = this.search(s);
                if (admitPrefix) {
                    if (childIndex == 0 || childIndex == -1) {
                        if (this.hasPayload()) {
                            payloadedNode = this.position;
                        }
                    } else {
                        payloadedNode = -1L;
                    }
                }
                limitByte = 256;
                if (atLimit && s < (limitByte = this.limit.next())) {
                    atLimit = false;
                }
                if (childIndex < 0) break;
                prev = new IterationPosition(this.position, childIndex, limitByte, prev);
                this.go(this.transition(childIndex));
            }
            childIndex = -1 - childIndex - 1;
            this.stack = new IterationPosition(this.position, childIndex, limitByte, prev);
            this.next = payloadedNode != -1L ? payloadedNode : this.advanceNode();
        }
        catch (Throwable t) {
            super.close();
            throw t;
        }
    }

    private void initializeNoLeftBound(long root, int limitByte) {
        this.stack = new IterationPosition(root, -1, limitByte, null);
        try {
            this.go(root);
            this.next = this.hasPayload() ? root : this.advanceNode();
        }
        catch (Throwable t) {
            super.close();
            throw t;
        }
    }

    protected long peekNode() {
        return this.next;
    }

    protected long nextPayloadedNode() {
        long toReturn = this.next;
        if (this.next != -1L) {
            this.next = this.advanceNode();
        }
        return toReturn;
    }

    protected ByteComparable nextCollectedValue() {
        assert (this.collector != null) : "Cannot get a collected value from a non-collecting iterator";
        return this.collector.toByteComparable();
    }

    protected long advanceNode() {
        this.go(this.stack.node);
        while (true) {
            int childIndex;
            int transitionByte;
            if ((transitionByte = this.transitionByte(childIndex = this.stack.childIndex + 1)) > this.stack.limit) {
                this.stack = this.stack.prev;
                if (this.collector != null) {
                    this.collector.pop();
                }
                if (this.stack == null) {
                    return -1L;
                }
                this.go(this.stack.node);
                continue;
            }
            long child = this.transition(childIndex);
            if (child != (long)NONE) {
                assert (child >= 0L) : String.format("Expected value >= 0 but got %d - %s", child, this);
                this.go(child);
                int l = 256;
                if (transitionByte == this.stack.limit) {
                    l = this.limit.next();
                }
                this.stack.childIndex = childIndex;
                this.stack = new IterationPosition(child, -1, l, this.stack);
                if (this.collector != null) {
                    this.collector.add(transitionByte);
                }
                if (this.payloadFlags() == 0) continue;
                return child;
            }
            this.stack.childIndex = childIndex;
        }
    }

    public static class IterationPosition {
        final long node;
        final int limit;
        final IterationPosition prev;
        int childIndex;

        public IterationPosition(long node, int childIndex, int limit, IterationPosition prev) {
            this.node = node;
            this.childIndex = childIndex;
            this.limit = limit;
            this.prev = prev;
        }

        public String toString() {
            return String.format("[Node %d, child %d, limit %d]", this.node, this.childIndex, this.limit);
        }
    }
}

