/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.tries.TrieNode;
import org.apache.cassandra.io.util.PageAware;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.lucene.util.ArrayUtil;

@NotThreadSafe
public class Walker<CONCRETE extends Walker<CONCRETE>>
implements AutoCloseable {
    public static int NONE = -1;
    private final Rebufferer source;
    protected final long root;
    private Rebufferer.BufferHolder bh;
    private int offset;
    protected TrieNode nodeType;
    protected ByteBuffer buf;
    protected long position;
    protected long greaterBranch;
    protected long lesserBranch;
    public static final ByteComparable.Version BYTE_COMPARABLE_VERSION = ByteComparable.Version.OSS50;

    public Walker(Rebufferer source, long root) {
        this.source = source;
        this.root = root;
        try {
            this.bh = source.rebuffer(root);
            this.buf = this.bh.buffer();
        }
        catch (RuntimeException ex) {
            if (this.bh != null) {
                this.bh.release();
            }
            source.closeReader();
            throw ex;
        }
    }

    @Override
    public void close() {
        this.bh.release();
        this.source.closeReader();
    }

    protected final void go(long position) {
        long curOffset = position - this.bh.offset();
        if (curOffset < 0L || curOffset >= (long)this.buf.limit()) {
            this.bh.release();
            this.bh = Rebufferer.EMPTY;
            this.bh = this.source.rebuffer(position);
            this.buf = this.bh.buffer();
            curOffset = position - this.bh.offset();
            assert (curOffset >= 0L && curOffset < (long)this.buf.limit()) : String.format("Invalid offset: %d, buf: %s, bh: %s", curOffset, this.buf, this.bh);
        }
        this.offset = (int)curOffset;
        this.position = position;
        this.nodeType = TrieNode.at(this.buf, (int)curOffset);
    }

    protected final int payloadFlags() {
        return this.nodeType.payloadFlags(this.buf, this.offset);
    }

    protected final boolean hasPayload() {
        return this.payloadFlags() != 0;
    }

    protected final int payloadPosition() {
        return this.nodeType.payloadPosition(this.buf, this.offset);
    }

    protected final int search(int transitionByte) {
        return this.nodeType.search(this.buf, this.offset, transitionByte);
    }

    protected final long transition(int childIndex) {
        return this.nodeType.transition(this.buf, this.offset, this.position, childIndex);
    }

    protected final long lastTransition() {
        return this.nodeType.lastTransition(this.buf, this.offset, this.position);
    }

    protected final long greaterTransition(int searchIndex, long defaultValue) {
        return this.nodeType.greaterTransition(this.buf, this.offset, this.position, searchIndex, defaultValue);
    }

    protected final long lesserTransition(int searchIndex, long defaultValue) {
        return this.nodeType.lesserTransition(this.buf, this.offset, this.position, searchIndex, defaultValue);
    }

    protected final int transitionByte(int childIndex) {
        return this.nodeType.transitionByte(this.buf, this.offset, childIndex);
    }

    protected final int transitionRange() {
        return this.nodeType.transitionRange(this.buf, this.offset);
    }

    protected final boolean hasChildren() {
        return this.transitionRange() > 0;
    }

    protected final void goMax(long pos) {
        this.go(pos);
        long lastChild;
        while ((lastChild = this.lastTransition()) != (long)NONE) {
            this.go(lastChild);
        }
        return;
    }

    protected final void goMin(long pos) {
        this.go(pos);
        int payloadBits;
        while ((payloadBits = this.payloadFlags()) <= 0) {
            long firstChild = this.transition(0);
            if (firstChild == (long)NONE) {
                return;
            }
            this.go(firstChild);
        }
        return;
    }

    public int follow(ByteComparable key) {
        ByteSource stream = key.asComparableBytes(BYTE_COMPARABLE_VERSION);
        this.go(this.root);
        int b;
        int childIndex;
        while ((childIndex = this.search(b = stream.next())) >= 0) {
            this.go(this.transition(childIndex));
        }
        return b;
    }

    public int followWithGreater(ByteComparable key) {
        this.greaterBranch = NONE;
        ByteSource stream = key.asComparableBytes(BYTE_COMPARABLE_VERSION);
        this.go(this.root);
        while (true) {
            int b = stream.next();
            int searchIndex = this.search(b);
            this.greaterBranch = this.greaterTransition(searchIndex, this.greaterBranch);
            if (searchIndex < 0) {
                return b;
            }
            this.go(this.transition(searchIndex));
        }
    }

    public int followWithLesser(ByteComparable key) {
        this.lesserBranch = NONE;
        ByteSource stream = key.asComparableBytes(BYTE_COMPARABLE_VERSION);
        this.go(this.root);
        while (true) {
            int b = stream.next();
            int searchIndex = this.search(b);
            this.lesserBranch = this.lesserTransition(searchIndex, this.lesserBranch);
            if (searchIndex < 0) {
                return b;
            }
            this.go(this.transition(searchIndex));
        }
    }

    public <RESULT> RESULT prefix(ByteComparable key, Extractor<RESULT, CONCRETE> extractor) throws IOException {
        RESULT payload = null;
        ByteSource stream = key.asComparableBytes(BYTE_COMPARABLE_VERSION);
        this.go(this.root);
        while (true) {
            int b;
            int childIndex;
            if ((childIndex = this.search(b = stream.next())) > 0) {
                payload = null;
            } else {
                int payloadBits = this.payloadFlags();
                if (payloadBits > 0) {
                    payload = extractor.extract(this, this.payloadPosition(), payloadBits);
                }
                if (childIndex < 0) {
                    return payload;
                }
            }
            this.go(this.transition(childIndex));
        }
    }

    public <RESULT> RESULT prefixAndNeighbours(ByteComparable key, Extractor<RESULT, CONCRETE> extractor) throws IOException {
        Object payload = null;
        this.greaterBranch = NONE;
        this.lesserBranch = NONE;
        ByteSource stream = key.asComparableBytes(BYTE_COMPARABLE_VERSION);
        this.go(this.root);
        while (true) {
            int b = stream.next();
            int searchIndex = this.search(b);
            this.greaterBranch = this.greaterTransition(searchIndex, this.greaterBranch);
            if (searchIndex == -1 || searchIndex == 0) {
                int payloadBits = this.payloadFlags();
                if (payloadBits > 0) {
                    payload = extractor.extract(this, this.payloadPosition(), payloadBits);
                }
            } else {
                this.lesserBranch = this.lesserTransition(searchIndex, this.lesserBranch);
                payload = null;
            }
            if (searchIndex < 0) {
                return payload;
            }
            this.go(this.transition(searchIndex));
        }
    }

    public ByteComparable getMaxTerm() {
        TransitionBytesCollector collector = new TransitionBytesCollector();
        this.go(this.root);
        while (true) {
            int lastIdx = this.transitionRange() - 1;
            long lastChild = this.transition(lastIdx);
            if (lastIdx < 0) {
                return collector.toByteComparable();
            }
            collector.add(this.transitionByte(lastIdx));
            this.go(lastChild);
        }
    }

    public ByteComparable getMinTerm() {
        TransitionBytesCollector collector = new TransitionBytesCollector();
        this.go(this.root);
        while (!this.hasPayload()) {
            collector.add(this.transitionByte(0));
            this.go(this.transition(0));
        }
        return collector.toByteComparable();
    }

    protected int nodeTypeOrdinal() {
        return this.nodeType.ordinal;
    }

    protected int nodeSize() {
        return this.payloadPosition() - this.offset;
    }

    public void dumpTrie(PrintStream out, PayloadToString payloadReader, Version version) throws IOException {
        out.print("ROOT");
        this.dumpTrie(out, payloadReader, this.root, "", version);
    }

    private void dumpTrie(PrintStream out, PayloadToString payloadReader, long node, String indent, Version version) throws IOException {
        this.go(node);
        int bits = this.payloadFlags();
        out.format(" %s@%x %s%n", this.nodeType.toString(), node, bits == 0 ? "" : payloadReader.payloadAsString(this.buf, this.payloadPosition(), bits, version));
        int range = this.transitionRange();
        for (int i = 0; i < range; ++i) {
            long child = this.transition(i);
            if (child == (long)NONE) continue;
            out.format("%s%02x %s>", indent, this.transitionByte(i), PageAware.pageStart(this.position) == PageAware.pageStart(child) ? "--" : "==");
            this.dumpTrie(out, payloadReader, child, indent + "  ", version);
            this.go(node);
        }
    }

    public String toString() {
        return String.format("[Trie Walker - NodeType: %s, source: %s, buffer: %s, buffer file offset: %d, Node buffer offset: %d, Node file position: %d]", this.nodeType, this.source, this.buf, this.bh.offset(), this.offset, this.position);
    }

    public static class TransitionBytesCollector {
        protected byte[] bytes = new byte[32];
        protected int pos = 0;

        public void add(int b) {
            if (this.pos == this.bytes.length) {
                this.bytes = ArrayUtil.grow((byte[])this.bytes, (int)(this.pos + 1));
            }
            this.bytes[this.pos++] = (byte)b;
        }

        public void pop() {
            assert (this.pos >= 0);
            --this.pos;
        }

        public ByteComparable toByteComparable() {
            if (this.pos <= 0) {
                return null;
            }
            byte[] value = new byte[this.pos];
            System.arraycopy(this.bytes, 0, value, 0, this.pos);
            return v -> ByteSource.fixedLength(value, 0, value.length);
        }

        public String toString() {
            return String.format("[Bytes %s, pos %d]", Arrays.toString(this.bytes), this.pos);
        }
    }

    public static interface PayloadToString {
        public String payloadAsString(ByteBuffer var1, int var2, int var3, Version var4) throws IOException;
    }

    public static interface Extractor<RESULT, VALUE> {
        public RESULT extract(VALUE var1, int var2, int var3) throws IOException;
    }
}

