/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.cassandra.net.ManyToOneConcurrentLinkedQueueHead;
import org.apache.cassandra.net.ManyToOneConcurrentLinkedQueuePadding1;

class ManyToOneConcurrentLinkedQueue<E>
extends ManyToOneConcurrentLinkedQueueHead<E>
implements Queue<E> {
    protected long p31;
    protected long p32;
    protected long p33;
    protected long p34;
    protected long p35;
    protected long p36;
    protected long p37;
    protected long p38;
    protected long p39;
    protected long p40;
    protected long p41;
    protected long p42;
    protected long p43;
    protected long p44;
    protected long p45;

    ManyToOneConcurrentLinkedQueue() {
        this.head = this.tail = new ManyToOneConcurrentLinkedQueuePadding1.Node<Object>(null);
    }

    @Override
    public boolean isEmpty() {
        return this.relaxedIsEmpty();
    }

    boolean relaxedIsEmpty() {
        return null == this.head.next;
    }

    @Override
    public int size() {
        int size = 0;
        ManyToOneConcurrentLinkedQueuePadding1.Node next = this.head;
        while (null != (next = next.next)) {
            ++size;
        }
        return size;
    }

    @Override
    public E peek() {
        ManyToOneConcurrentLinkedQueuePadding1.Node next = this.head.next;
        if (null == next) {
            return null;
        }
        return next.item;
    }

    @Override
    public E element() {
        E item = this.peek();
        if (null == item) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public E poll() {
        ManyToOneConcurrentLinkedQueuePadding1.Node head = this.head;
        ManyToOneConcurrentLinkedQueuePadding1.Node next = head.next;
        if (null == next) {
            return null;
        }
        this.lazySetHead(next);
        head.lazySetNext(head);
        Object item = next.item;
        next.item = null;
        return item;
    }

    @Override
    public E remove() {
        E item = this.poll();
        if (null == item) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public boolean remove(Object o) {
        if (null == o) {
            throw new NullPointerException();
        }
        ManyToOneConcurrentLinkedQueuePadding1.Node prev = this.head;
        ManyToOneConcurrentLinkedQueuePadding1.Node next = prev.next;
        while (null != next) {
            if (o.equals(next.item)) {
                prev.lazySetNext(next.next);
                next.lazySetNext(next);
                next.item = null;
                return true;
            }
            prev = next;
            next = next.next;
        }
        return false;
    }

    void drain(Consumer<E> consumer) {
        E item;
        while ((item = this.poll()) != null) {
            consumer.accept(item);
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        this.internalOffer(e);
        return true;
    }

    E relaxedPeekLastAndOffer(E e) {
        return this.internalOffer(e);
    }

    private E internalOffer(E e) {
        ManyToOneConcurrentLinkedQueuePadding1.Node t;
        if (null == e) {
            throw new NullPointerException();
        }
        ManyToOneConcurrentLinkedQueuePadding1.Node<E> node = new ManyToOneConcurrentLinkedQueuePadding1.Node<E>(e);
        ManyToOneConcurrentLinkedQueuePadding1.Node p = t = this.tail;
        while (true) {
            ManyToOneConcurrentLinkedQueuePadding1.Node q;
            if ((q = p.next) == null) {
                if (!p.casNext(null, node)) continue;
                if (p != t) {
                    this.casTail(t, node);
                }
                return p.item;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

