/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Optional;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.SchemaTransformation;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.ViewMetadata;

public class SchemaTransformations {
    public static SchemaTransformation addKeyspace(KeyspaceMetadata keyspace, boolean ignoreIfExists) {
        return schema -> {
            KeyspaceMetadata existing = schema.getNullable(keyspace.name);
            if (existing != null) {
                if (ignoreIfExists) {
                    return schema;
                }
                throw new AlreadyExistsException(keyspace.name);
            }
            return schema.withAddedOrUpdated(keyspace);
        };
    }

    public static SchemaTransformation addTable(TableMetadata table, boolean ignoreIfExists) {
        return schema -> {
            KeyspaceMetadata keyspace = schema.getNullable(table.keyspace);
            if (keyspace == null) {
                throw RequestValidations.invalidRequest("Keyspace '%s' doesn't exist", table.keyspace);
            }
            if (keyspace.hasTable(table.name)) {
                if (ignoreIfExists) {
                    return schema;
                }
                throw new AlreadyExistsException(table.keyspace, table.name);
            }
            table.validate();
            return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.with(table)));
        };
    }

    public static SchemaTransformation addTypes(Types toAdd, boolean ignoreIfExists) {
        return schema -> {
            if (toAdd.isEmpty()) {
                return schema;
            }
            String keyspaceName = toAdd.iterator().next().keyspace;
            KeyspaceMetadata keyspace = schema.getNullable(keyspaceName);
            if (null == keyspace) {
                throw RequestValidations.invalidRequest("Keyspace '%s' doesn't exist", keyspaceName);
            }
            Types types = keyspace.types;
            for (UserType type : toAdd) {
                if (types.containsType(type.name)) {
                    if (ignoreIfExists) continue;
                    throw new ConfigurationException("Type " + type + " already exists in " + keyspaceName);
                }
                types = types.with(type);
            }
            return schema.withAddedOrReplaced(keyspace.withSwapped(types));
        };
    }

    public static SchemaTransformation addView(ViewMetadata view, boolean ignoreIfExists) {
        return schema -> {
            KeyspaceMetadata keyspace = schema.getNullable(view.keyspace());
            if (keyspace == null) {
                throw RequestValidations.invalidRequest("Cannot add view to non existing keyspace '%s'", view.keyspace());
            }
            if (keyspace.hasView(view.name())) {
                if (ignoreIfExists) {
                    return schema;
                }
                throw new AlreadyExistsException(view.keyspace(), view.name());
            }
            return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.views.with(view)));
        };
    }

    public static SchemaTransformation updateSystemKeyspace(final KeyspaceMetadata keyspace, final long generation) {
        return new SchemaTransformation(){

            @Override
            public Optional<Long> fixedTimestampMicros() {
                return Optional.of(generation);
            }

            @Override
            public Keyspaces apply(Keyspaces schema) {
                KeyspaceMetadata updatedKeyspace = keyspace;
                KeyspaceMetadata curKeyspace = schema.getNullable(keyspace.name);
                if (curKeyspace != null) {
                    updatedKeyspace = updatedKeyspace.withSwapped(curKeyspace.params);
                    for (TableMetadata curTable : curKeyspace.tables) {
                        TableMetadata desiredTable = updatedKeyspace.tables.getNullable(curTable.name);
                        if (desiredTable == null) {
                            updatedKeyspace = updatedKeyspace.withSwapped(updatedKeyspace.tables.with(curTable));
                            continue;
                        }
                        updatedKeyspace = updatedKeyspace.withSwapped(updatedKeyspace.tables.without(desiredTable));
                        TableMetadata.Builder updatedBuilder = desiredTable.unbuild();
                        for (ColumnMetadata column : curTable.regularAndStaticColumns()) {
                            if (desiredTable.regularAndStaticColumns().contains(column)) continue;
                            updatedBuilder.addColumn(column);
                        }
                        updatedKeyspace = updatedKeyspace.withSwapped(updatedKeyspace.tables.with(updatedBuilder.build()));
                    }
                }
                return schema.withAddedOrReplaced(updatedKeyspace);
            }
        };
    }
}

