/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TimeSerializer
extends TypeSerializer<Long> {
    public static final Pattern timePattern = Pattern.compile("^-?\\d+$");
    public static final TimeSerializer instance = new TimeSerializer();

    @Override
    public <V> Long deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : Long.valueOf(accessor.toLong(value));
    }

    @Override
    public ByteBuffer serialize(Long value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    public static Long timeStringToLong(String source) throws MarshalException {
        if (timePattern.matcher(source).matches()) {
            try {
                long result = Long.parseLong(source);
                if (result < 0L || result >= TimeUnit.DAYS.toNanos(1L)) {
                    throw new NumberFormatException("Input long out of bounds: " + source);
                }
                return result;
            }
            catch (NumberFormatException e) {
                throw new MarshalException(String.format("Unable to make long (for time) from: '%s'", source), e);
            }
        }
        try {
            return TimeSerializer.parseTimeStrictly(source);
        }
        catch (IllegalArgumentException e1) {
            throw new MarshalException(String.format("(TimeType) Unable to coerce '%s' to a formatted time (long)", source), e1);
        }
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 8) {
            throw new MarshalException(String.format("Expected 8 byte long for time (%d)", accessor.size(value)));
        }
    }

    @Override
    public boolean shouldQuoteCQLLiterals() {
        return true;
    }

    @Override
    public String toString(Long value) {
        if (value == null) {
            return "null";
        }
        int nano = (int)(value % 1000L);
        value = value - (long)nano;
        value = value / 1000L;
        int micro = (int)(value % 1000L);
        value = value - (long)micro;
        value = value / 1000L;
        int milli = (int)(value % 1000L);
        value = value - (long)milli;
        value = value / 1000L;
        int seconds = (int)(value % 60L);
        value = value - (long)seconds;
        value = value / 60L;
        int minutes = (int)(value % 60L);
        value = value - (long)minutes;
        value = value / 60L;
        int hours = (int)(value % 24L);
        value = value - (long)hours;
        value = value / 24L;
        assert (value == 0L);
        StringBuilder sb = new StringBuilder();
        this.leftPadZeros(hours, 2, sb);
        sb.append(":");
        this.leftPadZeros(minutes, 2, sb);
        sb.append(":");
        this.leftPadZeros(seconds, 2, sb);
        sb.append(".");
        this.leftPadZeros(milli, 3, sb);
        this.leftPadZeros(micro, 3, sb);
        this.leftPadZeros(nano, 3, sb);
        return sb.toString();
    }

    private void leftPadZeros(int value, int digits, StringBuilder sb) {
        for (int i = 1; i < digits; ++i) {
            if (!((double)value < Math.pow(10.0, i))) continue;
            sb.append("0");
        }
        sb.append(value);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    private static Long parseTimeStrictly(String s) throws IllegalArgumentException {
        long second;
        long minute;
        long hour;
        long a_nanos = 0L;
        String formatError = "Timestamp format must be hh:mm:ss[.fffffffff]";
        String zeros = "000000000";
        if (s == null) {
            throw new IllegalArgumentException(formatError);
        }
        s = s.trim();
        int firstColon = s.indexOf(58);
        int secondColon = s.indexOf(58, firstColon + 1);
        if (firstColon > 0 && secondColon > 0 && secondColon < s.length() - 1) {
            int period = s.indexOf(46, secondColon + 1);
            hour = Integer.parseInt(s.substring(0, firstColon));
            if (hour < 0L || hour >= 24L) {
                throw new IllegalArgumentException("Hour out of bounds.");
            }
            minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
            if (minute < 0L || minute >= 60L) {
                throw new IllegalArgumentException("Minute out of bounds.");
            }
            if (period > 0 && period < s.length() - 1) {
                second = Integer.parseInt(s.substring(secondColon + 1, period));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
                Object nanos_s = s.substring(period + 1);
                if (((String)nanos_s).length() > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(((String)nanos_s).charAt(0))) {
                    throw new IllegalArgumentException(formatError);
                }
                nanos_s = (String)nanos_s + zeros.substring(0, 9 - ((String)nanos_s).length());
                a_nanos = Integer.parseInt((String)nanos_s);
            } else {
                if (period > 0) {
                    throw new IllegalArgumentException(formatError);
                }
                second = Integer.parseInt(s.substring(secondColon + 1));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
            }
        } else {
            throw new IllegalArgumentException(formatError);
        }
        long rawTime = 0L;
        rawTime += TimeUnit.HOURS.toNanos(hour);
        rawTime += TimeUnit.MINUTES.toNanos(minute);
        rawTime += TimeUnit.SECONDS.toNanos(second);
        return rawTime += a_nanos;
    }
}

