/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

public enum StreamOperation {
    OTHER("Other", true, false),
    RESTORE_REPLICA_COUNT("Restore replica count", false, false),
    DECOMMISSION("Unbootstrap", false, true),
    RELOCATION("Relocation", false, true),
    BOOTSTRAP("Bootstrap", false, true),
    REBUILD("Rebuild", false, true),
    BULK_LOAD("Bulk Load", true, false),
    REPAIR("Repair", true, false);

    private final String description;
    private final boolean requiresViewBuild;
    private final boolean keepSSTableLevel;

    private StreamOperation(String description, boolean requiresViewBuild, boolean keepSSTableLevel) {
        this.description = description;
        this.requiresViewBuild = requiresViewBuild;
        this.keepSSTableLevel = keepSSTableLevel;
    }

    public static StreamOperation fromString(String text) {
        for (StreamOperation b : StreamOperation.values()) {
            if (!b.description.equalsIgnoreCase(text)) continue;
            return b;
        }
        return OTHER;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresViewBuild() {
        return this.requiresViewBuild;
    }

    public boolean keepSSTableLevel() {
        return this.keepSSTableLevel;
    }
}

