/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="relocatesstables", description="Relocates sstables to the correct disk")
public class RelocateSSTables
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table>", description="The keyspace and table name")
    private List<String> args = new ArrayList<String>();
    @Option(title="jobs", name={"-j", "--jobs"}, description="Number of sstables to relocate simultanously, set to 0 to use all available compaction threads")
    private int jobs = 2;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] cfnames = this.parseOptionalTables(this.args);
        try {
            for (String keyspace : keyspaces) {
                probe.relocateSSTables(this.jobs, keyspace, cfnames);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Got error while relocating", e);
        }
    }
}

