/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.util.concurrent.AtomicDouble;
import org.apache.cassandra.utils.MovingAverage;

public class ExpMovingAverage
implements MovingAverage {
    private final double alpha;
    private final AtomicDouble average = new AtomicDouble(Double.NaN);

    public static MovingAverage decayBy1000() {
        return new ExpMovingAverage(0.0046);
    }

    public static ExpMovingAverage decayBy100() {
        return new ExpMovingAverage(0.045);
    }

    public static ExpMovingAverage decayBy10() {
        return new ExpMovingAverage(0.37);
    }

    public static ExpMovingAverage withDecay(double ratio, int samples) {
        assert (ratio > 0.0 && ratio < 1.0);
        assert (samples > 0);
        return new ExpMovingAverage(1.0 - Math.pow(ratio, 1.0 / (double)samples));
    }

    ExpMovingAverage(double alpha) {
        assert (alpha > 0.0 && alpha <= 1.0);
        this.alpha = alpha;
    }

    @Override
    public MovingAverage update(double val) {
        double update;
        double current;
        while (!this.average.compareAndSet(current, update = !Double.isNaN(current = this.average.get()) ? current + this.alpha * (val - current) : val)) {
        }
        return this;
    }

    @Override
    public double get() {
        return this.average.get();
    }

    public String toString() {
        return String.format("%.2f", this.get());
    }
}

